/* 
   Functions.m

   Generic Functions for the GNUstep GUI X/RAW Library.

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Scott Christley <scottc@net-community.com>
   Author:  Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: September 1996
   Author:  Felipe A. Rodriguez <far@ix.netcom.com>
   Date: May 1998
   
   This file is part of the GNUstep GUI X/RAW Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/ 

#include <AppKit/NSGraphics.h>
#include <AppKit/NSCStringText.h>
#include <AppKit/NSEvent.h>

#include <gnustep/xraw/XRContext.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>


//
// Rectangle Drawing Functions
//
//
// Optimize Drawing
//
void NSEraseRect(NSRect aRect)           			
{													// fill rect with white.
	[[NSColor whiteColor] set];
	NSRectFill(aRect);							
}

void NSDrawWhiteBezel(NSRect aRect, NSRect clipRect)  	// like a TextField ?
{
	NSDrawGrayBezel(aRect, clipRect);
}

void NSDrawBezel(NSRect aRect, NSRect clipRect)
{
	NSDrawGrayBezel(aRect, clipRect);
}

//*****************************************************************************
//
// 		Draws an unfilled rectangle, clipped by clipRect, whose border
//		is defined by the parallel arrays sides and grays, both of length
//		count. Each element of sides specifies an edge of the rectangle,
//		which is drawn with a width of 1.0 using the corresponding gray level
//		from grays. If the edges array contains recurrences of the same edge, 
//		each is inset within the previous edge.
//
//*****************************************************************************

NSRect NSDrawTiledRects(NSRect boundsRect, NSRect clipRect, 
						const NSRectEdge *sides, const float *grays, int count)
{
	return NSZeroRect;
}

//
// Color Functions
//
//
// Get Information About Color Space and Window Depth
//
const NSWindowDepth *NSAvailableWindowDepths(void)
{
	return NULL;
}

NSWindowDepth NSBestDepth(NSString *colorSpace, 
			  int bitsPerSample, int bitsPerPixel, 
			  BOOL planar, BOOL *exactMatch)
{
	return 0;
}

int NSBitsPerPixelFromDepth(NSWindowDepth depth)
{
	return 0;
}

int NSBitsPerSampleFromDepth(NSWindowDepth depth)
{
	return 0;
}

NSString *NSColorSpaceFromDepth(NSWindowDepth depth)
{
	return nil;
}

int NSNumberOfColorComponents(NSString *colorSpaceName)
{
	return 0;
}

BOOL NSPlanarFromDepth(NSWindowDepth depth)
{
	return NO;
}

//
// Read the Color at a Screen Position
//
NSColor *NSReadPixel(NSPoint location)
{
	return nil;
}

//
// Text Functions
//
//
// Filter Characters Entered into a Text Object
//
unsigned short NSEditorFilter(unsigned short theChar, 
			      int flags, NSStringEncoding theEncoding)
{
	return 0;
}

unsigned short NSFieldFilter(unsigned short theChar, 
			     int flags, NSStringEncoding theEncoding)
{
	return 0;
}

//
// Calculate or Draw a Line of Text (in Text Object)
//
int NSDrawALine(id self, NSLayInfo *layInfo)
{
	return 0;
}

int NSScanALine(id self, NSLayInfo *layInfo)
{
	return 0;
}

//
// Calculate Font Ascender, Descender, and Line Height (in Text Object)
//
void NSTextFontInfo(id fid, 
		    float *ascender, float *descender, 
		    float *lineHeight)
{}

//
// Access Text Object's Word Tables
//
NSData * NSDataWithWordTable(const unsigned char *smartLeft,
			     const unsigned char *smartRight,
			     const unsigned char *charClasses,
			     const NSFSM *wrapBreaks,
			     int wrapBreaksCount,
			     const NSFSM *clickBreaks, 
			     int clickBreaksCount, 
			     BOOL charWrap)
{
	return nil;
}

void NSReadWordTable(NSZone *zone,
		     NSData *data,
		     unsigned char **smartLeft,
		     unsigned char **smartRight,
		     unsigned char **charClasses,
		     NSFSM **wrapBreaks,
		     int *wrapBreaksCount,
		     NSFSM **clickBreaks,
		     int *clickBreaksCount, 
		     BOOL *charWrap)
{}

//
// Array Allocation Functions for Use by the NSText Class
//
NSTextChunk *NSChunkCopy(NSTextChunk *pc, NSTextChunk *dpc)
{
	return NULL;
}

NSTextChunk *NSChunkGrow(NSTextChunk *pc, int newUsed)
{
	return NULL;
}

NSTextChunk *NSChunkMalloc(int growBy, int initUsed)
{
	return NULL;
}

NSTextChunk *NSChunkRealloc(NSTextChunk *pc)
{
	return NULL;
}

NSTextChunk *NSChunkZoneCopy(NSTextChunk *pc, 
                             NSTextChunk *dpc,
                             NSZone *zone)
{
	return NULL;
}

NSTextChunk *NSChunkZoneGrow(NSTextChunk *pc, int newUsed, NSZone *zone)
{
	return NULL;
}

NSTextChunk *NSChunkZoneMalloc(int growBy, int initUsed, NSZone *zone)
{
	return NULL;
}

NSTextChunk *NSChunkZoneRealloc(NSTextChunk *pc, NSZone *zone)
{
	return NULL;
}


//
// Imaging Functions
//
//
// Copy an image
//
void NSCopyBitmapFromGState(int srcGstate, NSRect srcRect, NSRect destRect)
{}

void NSCopyBits(int srcGstate, NSRect srcRect, NSPoint destPoint)
{}

//
// Render Bitmap Images
//
void NSDrawBitmap(NSRect rect,
                  int pixelsWide,
                  int pixelsHigh,
                  int bitsPerSample,
                  int samplesPerPixel,
                  int bitsPerPixel,
                  int bytesPerRow, 
                  BOOL isPlanar,
                  BOOL hasAlpha, 
                  NSString *colorSpaceName, 
                  const unsigned char *const data[5])
{}

//
// Play the System Beep
//
void NSBeep(void)
{
	XBell([XRContext currentXDisplay], 50);
}

//
// Draw a Distinctive Outline around Linked Data
//
void NSFrameLinkRect(NSRect aRect, BOOL isDestination)
{}

float NSLinkFrameThickness(void)
{
	return 0;
}

//*****************************************************************************
//
//	X utility functions
//
//		_sendKeyCode	send a KeyCode to an X window
//		_sendKeysym		send a Keysym to an X window
//		_sendXString 	send a text string to an X window
//		_findXWindow	find lowest X window for a given global coordinate
//
//		inspired by E F Johnson's examples in Advanced X Window Applications 
//		Programming, 2nd ed.
//
//*****************************************************************************

static int 
_sendKeyCode(Display* display, Window window, KeyCode keycode, int state)
{   
static XKeyEvent event;								// Send a keycode to an X
int status;											// window
XEvent *xEvent;

    event.type        = KeyPress;					// fill in all fields of
    event.display     = display;					// the event structure.
    event.window      = window;	
    event.root        = RootWindow(display, DefaultScreen(display));
    event.keycode     = keycode;
    event.state       = state;
    event.time        = CurrentTime;
    event.same_screen = True;
    event.x           = 0;   
    event.y           = 0;   
    event.x_root      = 0;   
    event.y_root      = 0;   
    event.subwindow   = (Window)None;

	xEvent = (XEvent *)&event;

	status = XSendEvent(display, window, False, KeyPressMask, xEvent);

    if ( status != 0 ) 								// if send is successful
		{											// send a KeyRelease event
        event.type = KeyRelease;					// for each KeyPress event
        event.time = CurrentTime;					// sent

        status = XSendEvent(display, window, True, KeyReleaseMask, xEvent);
		}

    return status;
}   

static int 
_sendKeysym(Display* display, Window window, KeySym keysym)
{   
KeyCode	keycode;									// send a KeySym to an X 
int		status = 0;									// window
int		state;

    if (keysym != NoSymbol) 
		{
        if (( keysym >= XK_A ) && ( keysym <= XK_Z )) 
            state = ShiftMask;
		else 
            state = 0x00;
															// translate Keysym
        keycode = XKeysymToKeycode(display, keysym);		// to Keycode

        if ( keycode != 0 ) 								// send Keycode
            status = _sendKeyCode( display, window, keycode, state );
    	}

    return status;
}   

int 
 _sendXString(Display* display, Window window, const char* string)
{   
int	i;										// send a text string to another X
int	status = 0;								// window as a series of KeyPress 
											// and KeyRelease events
    for (i = 0; string[i] != '\0'; i++) 
		{
		if(string[i] == '\n')
			status = _sendKeysym(display, window, XK_Return);		// send CR
		else
        	status = _sendKeysym(display, window, string[i]);

        if (status == 0) 					// return immediately on errors
            return status;
    	}
															
    XFlush(display);
       
    return status;
}   

Window _findXWindow(Display* display, 
					Window topwindow, 
					Window window_to_check, 
					int x, int y)
{   										// find the lowest X window in the
int		newx, newy;							// heirarchy that the global x,y 
Window  window; 							// coordinates are in.

    if (topwindow == (Window) None) 		// validate function parameters
		{
		fprintf(stderr,"_findXWindow() error: topwindow == (Window) None \n");

        return (Window) None;
    	}

    if (window_to_check == (Window) None) 	// validate function parameters
		{
		fprintf(stderr,
				"_findXWindow() error: window_to_check == (Window) None \n");

        return topwindow;
    	}								// find lowest X window by iterating 
										// thru the X window's heirarchy while
	window = window_to_check;			// XTranslateCoordinates returns an X 
										// Window via the window ptr
    while (( XTranslateCoordinates(display, topwindow, window_to_check, 
									x, y, &newx, &newy, &window) != 0 ) 
									&& (window != (Window) None )) 
		{
        if ( window != (Window) None ) 
			{
            topwindow = window_to_check;
            window_to_check = window;
            x = newx;
            y = newy;
       		}
    	}

    if (window == (Window) None)
        window = window_to_check;

    return window;						
}  										
//*****************************************************************************
//
// 		copy a string buffer (this needs to be moved out of XRAW) 
//
//*****************************************************************************

char *
XRCopyStringBuffer(const char *buf)
{
char *out;

    if (!buf)
		return NULL;
    out = malloc(strlen(buf)+1 * sizeof(char));
    if (out)
        strcpy(out, buf);

    return out;
}

