/* 
   MyObject.m

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <config.h>

#include <stdio.h>
#include <Foundation/NSString.h>
#include <Foundation/NSArray.h>
#include <Foundation/NSDictionary.h>
#include <Foundation/NSUtilities.h>
#include <Foundation/NSAutoreleasePool.h>

#include <extensions/objc-runtime.h>

#include <eoaccess/EOEntity.h>
#include <eoaccess/EOExpressionArray.h>
#include <eoaccess/EOQualifier.h>

#if SYBASE_DATABASE
# include <eoadaptors/Sybase/SybaseAdaptor.h>
# include <eoadaptors/Sybase/SybaseChannel.h>
#endif

#include "MyObject.h"

@implementation MyObject

- method
{
    printf("%u method\n", (unsigned)self);
    return self;
}

- method:arg
{
    printf("%u method: %u\n", (unsigned)self, (unsigned)arg);
    return self;
}

- setName:(NSString*)_name
{
    [_name retain];
    [name release];
    name = _name;
    return self;
}

- setEntity:(EOEntity*)_entity
{
    [_entity retain];
    [entity release];
    entity = _entity;
    return self;
}

- (void)dealloc
{
    [name release];
    [entity release];
    [super dealloc];
}

- (NSString*)expressionValueForContext:(id<EOExpressionContext>)ctx
{
    return name;
}

+ (BOOL)verifyObject:anObject
{
    if([anObject retainCount] != 1) {
	printf("%u object has ref count %d (description is '%s')\n", \
		(unsigned)anObject, [anObject retainCount], \
		[[anObject description] cString]); \
	return NO;
    }

    if([anObject isKindOfClass:[NSArray class]]) {
	if([self verifyArray:anObject] == NO)
	    return NO;
    }

    if([anObject isKindOfClass:[NSDictionary class]]) {
	if([self verifyDict:anObject] == NO)
	    return NO;
    }
    return YES;
}

+ (BOOL)verifyArray:anObject
{
    id pool = [NSAutoreleasePool new];
    id enumerator = [anObject objectEnumerator];
    id elem;

    while((elem = [enumerator nextObject])) {
	if([self verifyObject:elem] == NO) {
	    [pool release];
	    return NO;
	}
    }
    [pool release];
    return YES;
}

+ (BOOL)verifyDict:anObject
{
    id pool = [NSAutoreleasePool new];
    id enumerator = [anObject keyEnumerator];
    id key, value;

    while((key = [enumerator nextObject])) {
	value = [anObject objectForKey:key];

	if([self verifyObject:key] == NO) {
	    [pool release];
	    return NO;
	}
	if([self verifyObject:value] == NO) {
	    [pool release];
	    return NO;
	}
    }
    [pool release];
    return YES;
}

- (EOQualifier*)qualifierWithFormat:(NSString*)format argument:(id)anObject
{
    return [[[EOQualifier alloc] autorelease]
		initWithEntity:entity qualifierFormat:format, anObject];
}

- (EOQualifier*)qualifierWithFormat:(NSString*)format
  floatArgument:(float)aFloat;
{
    return [[[EOQualifier alloc] autorelease]
		initWithEntity:entity qualifierFormat:format, aFloat];
}

- (NSMutableDictionary*)adaptorChannel:aChannel
  willFetchAttributes:(NSArray*)attributes
  withZone:(NSZone*)zone
{
    puts (sel_get_name (_cmd));
    return nil;
}

- (NSMutableDictionary*)adaptorChannel:aChannel
  didFetchAttributes:(NSMutableDictionary*)attributes
  withZone:(NSZone*)zone
{
    puts (sel_get_name (_cmd));
    return attributes;
}

@end /* MyObject */


#if SYBASE_DATABASE

@implementation MyObject (SybaseAdaptorDelegate)

- (NSMutableDictionary*)adaptorChannel:aChannel
  willFetchAttributes:(NSArray*)attributes
  withZone:(NSZone*)zone
{
    puts (sel_get_name (_cmd));
    return nil;
}

- (NSMutableDictionary*)adaptorChannel:aChannel
  didFetchAttributes:(NSMutableDictionary*)attributes
  withZone:(NSZone*)zone
{
    puts (sel_get_name (_cmd));
    return attributes;
}

- (NSArray*)sybaseChannel:(SybaseChannel*)channel
  willFetchAttributes:(NSArray*)attributes
  forRowOfType:(SybaseRowType)rowType
  withComputeRowId:(int)computeRowId
{
    printf ("%s, rowType = %d, computeRowId = %d\n",
	    sel_get_name (_cmd), rowType, computeRowId);
    if (rowType == SybaseRegularRow)
        return attributes;
	
    attributes = [(EOAdaptorChannel*)channel describeResults];
        return attributes;
}

- (BOOL)sybaseChannel:(SybaseChannel *)channel
    willReturnRow:(NSDictionary *)row ofType:(SybaseRowType)rowType 
    withComputeRowId:(int)computeRowId
{
    printf ("%s, rowType = %d, computeRowId = %d\n",
	    sel_get_name (_cmd), rowType, computeRowId);
    switch (rowType) {
	case SybaseRegularRow:
	    break;
	case SybaseComputeRow:
	    NSLog(@"Returning compute row");
	    break;
	case SybaseReturnParameterRow:
	    NSLog(@"Returning return parameter row: %@", [row description]);
	    break;
	case SybaseReturnStatusRow:
	    NSLog(@"Returning return status row: %@", [row description]);
	    break;
	default:
	    break;
    }
    
    return YES;
}

@end /* MyObject (sybaseAdaptorDelegate */

#endif /* SYBASE_DATABASE */
