/* 
   MyObject.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __MyObject_h__
#define __MyObject_h__

#include <Foundation/NSObject.h>

@class NSString;
@class EOEntity;

@interface MyObject : NSObject
{
    NSString* name;
    EOEntity* entity;
}

- method;
- method:arg;

- setName:(NSString*)name;
- setEntity:(EOEntity*)entity;
- (NSString*)expressionValueForContext:(id<EOExpressionContext>)ctx;

+ (BOOL)verifyObject:anObject;
+ (BOOL)verifyArray:anObject;
+ (BOOL)verifyDict:anObject;

- (EOQualifier*)qualifierWithFormat:(NSString*)format argument:(id)anObject;
- (EOQualifier*)qualifierWithFormat:(NSString*)format
  floatArgument:(float)aFloat;

- (NSMutableDictionary*)adaptorChannel:aChannel
  willFetchAttributes:(NSArray*)attributes
  withZone:(NSZone*)zone;
- (NSMutableDictionary*)adaptorChannel:aChannel
  didFetchAttributes:(NSMutableDictionary*)attributes
  withZone:(NSZone*)zone;
@end

#endif /* __MyObject_h__ */
