/* 
   CompiledTestMain.m

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Mircea Oancea <mircea@jupiter.elcom.pub.ro>
   Date: 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <Foundation/NSString.h>
#include <Foundation/NSDictionary.h>
#include <Foundation/NSArray.h>
#include <Foundation/NSAutoreleasePool.h>
#include <extensions/support.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#if !NeXT_foundation_LIBRARY
#include <Foundation/NSProcessInfo.h>
#endif

#include "CompiledTest.h"

void main(int argc, char** argv, char** envp)
{
    NSAutoreleasePool* gpool;
    NSAutoreleasePool* lpool;
    CompiledTest* compiledTest;

    NSString*		modelFile = nil;
    NSString*		testFile  = nil;
    NSString*		testName  = nil;
    
    NSDictionary*	modelPlist= nil;
    NSDictionary*	testPlist = nil;

#if LIB_FOUNDATION_LIBRARY
    [NSProcessInfo initializeWithArguments:argv count:argc environment:envp];
#endif

    [NSAutoreleasePool enableDoubleReleaseCheck:YES];

    gpool = [[NSAutoreleasePool alloc] init];
    
    if (argc != 4 && argc != 3) {
	fprintf(stderr, "usage: progname model-file [test-file] test-name \n");
	exit(1);
    }
    
    modelFile = [NSString stringWithCString:argv[1]];
    if (argc == 4) {
	testFile = [NSString stringWithCString:argv[2]];
	testName = [NSString stringWithCString:argv[3]];
    }
    else
	testName = [NSString stringWithCString:argv[2]];

    lpool = [[NSAutoreleasePool alloc] init];
    modelPlist = [[NSDictionary alloc] initWithContentsOfFile:modelFile];
    if (testFile)
	testPlist = [[NSDictionary alloc] initWithContentsOfFile:testFile];
    [lpool release];
    
    [modelPlist autorelease];
    [testPlist autorelease];
    
    if (!testPlist)
	testPlist = [[modelPlist objectForKey:@"userDictionary"]
			objectForKey:@"CompiledTest"];
    
    if (!modelPlist) {
	fprintf(stderr, "could not load model from file %s\n", argv[1]);
	exit(1);
    }
    
    if (!testPlist) {
	fprintf(stderr, "could not load test dictionary\n");
	exit(1);
    }
    
    
    compiledTest = [[CompiledTest alloc]
			initWithTestDict:testPlist
			modelDict:modelPlist
			forTest:testName];
    [compiledTest runMainTest];
    [compiledTest release];
    
    [gpool release];
    exit(0);
}

static void __dummyForStupidLinker(void)
{
    extern void __compiled_adaptor_linking();
    
    __dummyForStupidLinker();
    __compiled_adaptor_linking();
}
