/* 
   EORelationship.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: August 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __EORelationship_h__
#define __EORelationship_h__

#include <Foundation/NSString.h>

#include <extensions/GCObject.h>
#include <extensions/GCArray.h>

@class EOModel;
@class EOEntity;
@class EOJoin;

@interface EORelationship : GCObject
{
    NSString*	name;
    NSString*	definition;
    NSDictionary* userDictionary;

    /* Garbage collectable objects */
    EOEntity*	entity;
    EOEntity*	destinationEntity;
    GCArray*	joins;

    /* Computed values */
    GCArray* sourceAttributes;
    GCArray* destinationAttributes;
    GCMutableArray* componentRelationships;

    struct {
	BOOL	isFlattened:1;
	BOOL	isToMany:1;
	BOOL	createsMutableObjects:1;
    } flags;
}

/* Initializing instances */
- initWithName:(NSString*)name;

/* Accessing the name */
- (BOOL)setName:(NSString*)name;
- (NSString*)name;
+ (BOOL)isValidName:(NSString*)name;

/* Using joins */
- (BOOL)addJoin:(EOJoin*)join;
- (void)removeJoin:(EOJoin*)join;
- (NSArray*)joins;

/* Getting attributes joined on */
- (NSArray*)sourceAttributes;
- (NSArray*)destinationAttributes;

/* Convering source row in destination row */
- (NSDictionary*)foreignKeyForRow:(NSDictionary*)row;

/* Accessing the definition */
- (NSArray*)componentRelationships;
- (void)setDefinition:(NSString*)definition;
- (NSString*)definition;

/* Accessing the entities joined */
- (void)setEntity:(EOEntity*)entity;
- (EOEntity*)entity;
- (EOEntity*)destinationEntity;

/* Checking type */
- (BOOL)isCompound;
- (BOOL)isFlattened;

/* Accessing to-many property */
- (BOOL)setToMany:(BOOL)flag;
- (BOOL)isToMany;

/* Checking references */
- (BOOL)referencesProperty:property;

/* Accessing the user dictionary */
- (void)setUserDictionary:(NSDictionary*)dictionary;
- (NSDictionary*)userDictionary;

@end


@interface EORelationship (EORelationshipPrivate)

+ (EORelationship*)relationshipFromPropertyList:(id)propertyList
	model:(EOModel*)model;
- (void)replaceStringsWithObjects;
- (void)initFlattenedRelationship;

- (id)propertyList;

- (void)setCreateMutableObjects:(BOOL)flag;
- (BOOL)createsMutableObjects;

@end /* EORelationship (EORelationshipPrivate) */

#endif /* __EORelationship_h__ */
