// $Id: standard.cc,v 1.29 1998/10/09 14:28:32 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

void StandardWriter::AddChildren(File &f,const Widget &w,
					const string instance)
{  for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  AddChild(f,*i,instance);
   }
}

void StandardWriter::AddChild(File &f,const Widget &w,const string instance)
{  if (w.Class()=="Placeholder") return; // dirty hack
   f << instance << "add(" << f.Pointer(w) << ");\n\t";
}

void StandardWriter::ConstructCompound(File &f, Widget const &w, bool is_member)
{  // this is not needed until parametrized subwidgets exist
   f << f.TypeName(w.Name()) << "()";
   // "/* oh, oh, ConstructCompound() called */";
}

void StandardWriter::DeclareCompound(File &f, Widget const &w)
{  f << f.TypeName(w.Name()) << " " << f.Declaration(w) << ";";
}

void StandardWriter::ConstructPointer(File &f,const Widget &w)
{  f << "\t" << f.InstanceName(w.Name()) << " = new ";
   if (w.isCompound())
      ConstructCompound(f,w,false);
   else
      Writer(w).Construct(f,false);
   f << ";\n";
}

void StandardWriter::DestructPointer(File &f,const Widget &w)
{  f << "\tdelete " << f.InstanceName(w.Name()) << ";\n";
}

void Gtk_Widget::Customize(File &f,const Widget &w,const string instance,bool dontshow)
{  if (w.getBool("visible",true) && !dontshow)
   {  f << instance << "show();\n\t";
   }
   int width=w.getInt("width",-1);
   int height=w.getInt("height",-1);
   if (width!=-1 || height!=-1)
   {  f << instance << "set_usize(" << width << ", " << height << ");\n\t";
   }
   // uposition
   // events
   // style
   string name(w.getString("name",""));
   if (name.size())
   {  f << instance << "set_name(\"" << f.CString(name) << "\");\n\t";
   }
   // sensitive
   // tooltips
   if (w.hasTag("tooltip"))
   {  string tooltip(w.getString("tooltip",""));
      f << "_tooltips.set_tip(" << f.Pointer(w) << ", \"" << tooltip << "\", \"\");\n\t";
   }
}

void Gtk_Container::Customize(File &f,const Widget &w,const string instance,bool dontshow)
{  Gtk_Widget::Customize(f,w,instance,dontshow);
   int border_width=w.getInt("border_width",0);
   if (border_width)
      f << instance << "border_width(" << border_width << ");\n\t";
   // add???
}

void Gtk_Container::Include(File &f,const Widget &w)
{  bool children_have_tooltips=false;
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).hasTag("tooltip")) 
      {  children_have_tooltips=true;
         break;
      }
   }
   if (children_have_tooltips)
   {  f.include("gtk--/tooltips.h");
   }
}

void Gtk_Container::DeclareNeeded(File &f,const Widget &w)
{  bool children_have_tooltips=false;
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).hasTag("tooltip")) 
      {  children_have_tooltips=true;
         break;
      }
   }
   if (children_have_tooltips)
   {  f << "Gtk_Tooltips _tooltips;";
   }
}

void Gtk_Misc::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Widget::Customize(f,w,instance);
   float xalign(w.getFloat("xalign",0.5));
   float yalign(w.getFloat("yalign",0.5));
   f << instance << "set_alignment(" << xalign << ", " << yalign << ");\n\t";
   float xpad(w.getInt("xpad",0));
   float ypad(w.getInt("ypad",0));
   f << instance << "set_padding(" << xpad << ", " << ypad << ");\n\t";
}

const string Gtk_Widget::CallbackArgs(const Widget &w,const string signal,string &rettype)
{  if (signal=="draw") return "GdkRectangle *rect";
   if (signal=="size_request") return "GtkRequisition *req";
   if (signal=="size_allocate") return "GtkAllocation *all";
   if (signal=="state_changed") return "unsigned int state";
   if (signal=="event") { rettype="gint"; return "GdkEvent *ev"; }
   if (signal=="button_press_event" || signal=="button_release_event")
   { rettype="gint"; return "GdkEventButton *ev"; }
   if (signal=="motion_notify_event") { rettype="gint"; return "GdkEventMotion *ev"; }
   if (signal=="delete_event" || signal=="map_event" || signal=="unmap_event") 
   { rettype="gint"; return "GdkEventAny *ev"; }
   if (signal=="expose_event") { rettype="gint"; return "GdkEventExpose *ev"; }
   if (signal=="key_press_event" || signal=="key_release_event")
   { rettype="gint"; return "GdkEventKey *ev"; }
   if (signal=="enter_notify_event" || signal=="leave_notify_event")
   { rettype="gint"; return "GdkEventCrossing *ev"; }
   if (signal=="configure_event") { rettype="gint"; return "GdkEventConfigure *ev"; }
   if (signal=="focus_in_event" || signal=="focus_out_event")
   { rettype="gint"; return "GdkEventFocus *ev"; }
   if (signal=="property_notify_event") { rettype="gint"; return "GdkEventProperty *ev"; }
   if (signal=="selection_clear_event" || signal=="selection_request_event" || signal=="selection_notify_event") 
   { rettype="gint"; return "GdkEventSelection *ev"; }
   if (signal=="proximity_in_event" || signal=="proximity_out_event")
   { rettype="gint"; return "GdkEventProximity *ev"; }
   if (signal=="drag_begin_event") { rettype="gint"; return "GdkEventDragBegin *ev"; }
   if (signal=="drag_request_event") { rettype="gint"; return "GdkEventDragRequest *ev"; }
   if (signal=="drop_enter_event") { rettype="gint"; return "GdkEventDropEnter *ev"; }
   if (signal=="drop_leave_event") { rettype="gint"; return "GdkEventDropLeave *ev"; }
   if (signal=="drop_data_available_event") { rettype="gint"; return "GdkEventDropDataAvailable *ev"; }
   if (signal=="other_event") { rettype="gint"; return "GdkEventOther *ev"; }
   if (signal=="selection_received") return "GtkSelectionData *data";
   if (signal=="client_event") { rettype="gint"; return "GdkEventClient *ev"; }
   if (signal=="no_expose_event") { rettype="gint"; return "GdkEventAny *ev"; }
   return "";
}
