// $Id: optionmenu.cc,v 1.14 1998/10/07 14:13:30 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"
#include "../Configuration.hh"

void Gtk_OptionMenu::Include(File &f,const Widget &w)
{  f.include("gtk--/optionmenu.h");
   if (Configuration.sample_code || w.hasTag("items")) 
   {  f.include("gtk--/menu.h");
      f.include("vector");
   } 
   if (w.hasTag("items")) // we need control over destruction
   {  ((Widget)w).markPointer(); // this is an _ugly_ hack ... but it's the only way ?
   }
}

void Gtk_OptionMenu::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,"Gtk_OptionMenu");
}

void Gtk_OptionMenu::DeclareNeeded(File &f,const Widget &w)
{  if (w.hasTag("items"))
   {  const string name(f.InstanceName(w.Name()));
      f << "\tGtk_Menu *" << name << "_menu;\n";
      f << "\tvector<Gtk_MenuItem *> " << name << "_menuitems;\n";
   }
}

void Gtk_OptionMenu::Construct(File &f,const Widget &w,bool is_member)
{  
}

bool Gtk_OptionMenu::NeedConstruct(const Widget &w,bool is_member)
{  return false;
}

void Gtk_OptionMenu::ConstructPointer(File &f,const Widget &w)
{  const string name(f.InstanceName(w.Name()));
   f << "\t" << name << " = new Gtk_OptionMenu();\n";
   if (w.hasTag("items"))
   { f << "\t" << name << "_menu = new Gtk_Menu();\n";
   }
}

void Gtk_OptionMenu::DestructPointer(File &f,const Widget &w)
{  const string name(f.InstanceName(w.Name()));
   if (w.hasTag("items"))
   {   f << "\t" << name << (w.isPointer() ? "->" : "." )
              << "remove_menu();\n";
       f << "\tfor (vector<Gtk_MenuItem*>::iterator i=" << name 
              << "_menuitems.begin();i!=" << name << "_menuitems.end();++i)\n"
              << "\t\tdelete *i;\n";
       f << "\tdelete " << name << "_menu;\n";
   }
   f << "\tdelete " << name << ";\n";
}

void Gtk_OptionMenu::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Button::Customize(f,w,instance);
   // set_menu
   if (w.hasTag("items")) // append them
   {  const string items(w.getString("items","<none>\n"));
      const string name(f.InstanceName(w.Name()));
      char *buffer=(char*)alloca(items.size()+1);
      memcpy(buffer,items.c_str(),items.size()+1);
      char *token,*stringp=buffer;
      while ((token=strsep(&stringp,"\n")))
      {  if (!stringp && !token[0]) // do not use the last empty string
            break;
         f << name << "_menuitems.push_back(new Gtk_MenuItem(\"" << token << "\"));\n\t";
      }
      f << "for (vector<Gtk_MenuItem*>::iterator i=" << name 
              << "_menuitems.begin();\n\t\t\ti!=" << name << "_menuitems.end();++i)\n"
              << "\t{\t" << name << "_menu->append(*i);\n"
              << "\t\t(*i)->show();\n"
              << "\t}\n\t";
      int initial_choice=w.getInt("initial_choice",0);
      f << name << "_menu->set_active("<<initial_choice <<");\n\t";
      f << name << (w.isPointer() ? "->" : "." )
              << "set_menu(" << name << "_menu);\n\t";
   }
}

// FIXME: if widget is pointer, make menu also pointer

bool Gtk_OptionMenu::SampleCode(File &f,const Widget &w,enum WriterType::CodePosition pos,const string misc)
{  const string name(f.InstanceName(w.Name()));
   if (w.hasTag("items")) return false; // no example code needed ???
   switch(pos)
   {  case WriterType::ContainingConstructor:
         {  // insert items
            f << "\t" << name << "_menuitems.push_back(new Gtk_MenuItem(\"one\"));\n";
            f << "\t" << name << "_menuitems.push_back(new Gtk_MenuItem(\"three\"));\n";
            f << "\t" << name << "_menuitems.push_back(new Gtk_MenuItem(\"nine\"));\n";
            f << "\t" << name << "_menuitems.push_back(new Gtk_MenuItem(\"twentyseven\"));\n";
            f << "\tfor (vector<Gtk_MenuItem*>::iterator i=" << name 
              << "_menuitems.begin();\n\t\t\ti!=" << name << "_menuitems.end();++i)\n"
              << "\t{\t" << name << "_menu.append(*i);\n"
              << "\t\t(*i)->show();\n"
              << "\t}\n";
            f << "\t" << name << "_menu.set_active(0);\n";
            f << "\t// " << name << "_menu.show(); we don't need it initially open\n";
            f << "\t" << name << (w.isPointer() ? "->" : "." )
              << "set_menu(&" << name << "_menu);\n";
   	 }
   	 break;
      case WriterType::ContainingDestructor:
         {  f << "\t" << name << (w.isPointer() ? "->" : "." )
              << "remove_menu();\n";
            f << "\tfor (vector<Gtk_MenuItem*>::iterator i=" << name 
              << "_menuitems.begin();i!=" << name << "_menuitems.end();++i)\n"
              << "\t\tdelete *i;\n";
         }
         break;
      case WriterType::ContainingPrivateMember:
         {  f << "\tGtk_Menu " << name << "_menu;\n";
            f << "\tvector<Gtk_MenuItem *> " << name << "_menuitems;\n";
            f << "\t\t// Gtk-- 0.9.7 doesn't like vector<Gtk_MenuItem> !!!\n";
         }
         break;
      default: break;
   }
   return false;
}
