// $Id: menuitem.cc,v 1.4 1998/10/09 14:28:32 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

bool Gtk_MenuItem::IsBasic(const Widget &w)
{  return !w.hasChildren(); // true;
}

void Gtk_MenuItem::Include(File &f,const Widget &w)
{  f.include("gtk--/menuitem.h");
}

void Gtk_MenuItem::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,"Gtk_MenuItem");
}

void Gtk_MenuItem::Derive(File &f,const Widget &w)
{  f << "Gtk_MenuItem";
}

void Gtk_MenuItem::Construct(File &f,const Widget &w,bool is_member)
{  f << StandardWriter::ConstructName(f,w,is_member,"Gtk_MenuItem");
   f << "(\"" << f.CString(w.getString("label"))
	<< "\")";
}

bool Gtk_MenuItem::NeedConstruct(const Widget &w,bool is_member)
{  return w.hasTag("label");
}

void Gtk_MenuItem::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Container::Customize(f,w,instance);
   // set_submenu
   if (w.hasChildren())
   {  Widget child(*(w.begin()));
      f << instance << "set_submenu(" << f.Pointer(child) << ");\n\t";
   }
}
