// $Id: menu.cc,v 1.4 1998/10/09 14:28:31 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

bool Gtk_Menu::IsBasic(const Widget &w)
{  return false;
}

void Gtk_Menu::Include(File &f,const Widget &w)
{  f.include("gtk--/menu.h");
   Gtk_Container::Include(f,w);
}

void Gtk_Menu::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,"Gtk_Menu");
}

void Gtk_Menu::Derive(File &f,const Widget &w)
{  f << "Gtk_Menu";
}

void Gtk_Menu::Construct(File &f,const Widget &w,bool is_member)
{  f << StandardWriter::ConstructName(f,w,is_member,"Gtk_Menu")
     << "()";
}

bool Gtk_Menu::NeedConstruct(const Widget &w,bool is_member)
{  return false;
}

void Gtk_Menu::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Container::Customize(f,w,instance,true);
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).Class()=="Placeholder") continue;
      f << instance << "append(" << f.Pointer((*i)) << ");\n\t";
   }
}
