// $Id: Widget.cc,v 1.18 1998/09/24 13:21:44 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "Widget.hh"
#include <cstring>

static string UniqueName(const string prefix,const void *addr)
{  string ret(prefix);
   unsigned long val=(unsigned long)addr;
   if (sizeof(val)<sizeof(addr)) 
      cerr<<"Warning: Widget::UniqueName: truncating address\n";
   unsigned int bit;
   const int size=5;
   for (bit=0;bit<8*(sizeof val);bit+=size)
      ret+="QCDGHKLMJNPVWYZXqcdghklmjnpvwyzx"[(val>>bit)&((1<<size)-1)];
      // selecting really unreadable names
   return ret;
}

// there is a performance penalty for calling UniqueName each time ...
const string Widget::Name() const throw()
{  if (name.size()) return name;
   return ((string)name)=getString("name",UniqueName("Widget",tag));
}

bool Widget::hasTag(const string typ) const throw()
{  const Tag *t=tag->find(typ);
   return t!=0;
}

const string Widget::getString(const string typ,const string def) const throw()
{  const Tag *t=tag->find(typ);
   if (t) return t->Value(); // @@@
   return def;
}

bool Widget::getBool(const string typ,bool def) const throw()
{  const Tag *t=tag->find(typ);
   if (!t) return def;
   if (!strcasecmp(t->Value().c_str(),"true")) return true;
   if (!strcasecmp(t->Value().c_str(),"false")) return false;
   cerr << "strange bool Value for type <"<<typ<<"> \"" << t->Value()<<"\"\n";
   return getInt(typ,0);
}

int Widget::getInt(const string typ,int def) const throw()
{  const Tag *t=tag->find(typ);
   if (!t) return def;
   // 2do: check
   return atoi(t->Value().c_str());
}

float Widget::getFloat(const string typ,float def) const throw()
{  const Tag *t=tag->find(typ);
   if (!t) return def;
   // 2do: check
   return atof(t->Value().c_str());
}

void Widget::mark(const string tg) throw()
{  Tag *t=tag->find(tg);
   if (t) cerr<< Name() << ": <" << tg << "> already there\n";
   else tag->push_back(Tag(tg,"true"));
}

bool Widget::hasRequirements() const throw()
{  for (const_iterator i=begin();i!=end();++i)
      if ((*i).isCompound()) return true;
   return false;
}

const Widget Widget::get_Child_params() const throw()
{  Tag *t=tag->find("child");
   if (t) return Widget(t);
   return *this;
}

