// $Id: Tag.hh,v 1.6 1998/09/24 13:21:44 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef TAG_HH
#define TAG_HH
//#include <glib.h>
#include <string>
#include <vector>

class Tag {
    	string type;
    	string value;
    	vector <Tag> sub_specifications;
public:
    	Tag(string t,string v="") throw()
		: type(t), value(v)
	{}
	Tag &push_back(const Tag t) throw()
	{  sub_specifications.push_back(t);
	   return *(sub_specifications.end()-1);
	}
	typedef vector<Tag>::iterator iterator;
	typedef vector<Tag>::const_iterator const_iterator;
	const_iterator begin() const throw()
	{  return sub_specifications.begin(); }
	const_iterator end() const throw()
	{  return sub_specifications.end(); }
	iterator begin() throw()
	{  return sub_specifications.begin(); }
	iterator end() throw()
	{  return sub_specifications.end(); }
	string Type() const throw()
	{  return type; }
	string Value() const throw()
	{  return value; }
	bool        parse_bool_value();
	int         parse_int_value();
	long        parse_long_value();
	float       parse_float_value();
	double      parse_double_value();
	
	const Tag *find(const string type) const;
	const_iterator find(const_iterator it,const string type) const;
	Tag *find(const string type);
	iterator find(iterator it,const string type);
	
	bool operator==(const string tp) const
	{  return type==tp; }
	bool operator!=(const string tp) const
	{  return type!=tp; }
	
	void debug(bool recursive=true,int indent=0) const;
};
#endif
