// $Id: Naming.cc,v 1.15 1998/10/09 09:41:47 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "Naming.hh"
#include "Configuration.hh"
#include <cctype>
#include <unistd.h>
// kind of macro misuse, but everything else is non-portable
#define __FILELINE__ __FILE__ << ":" << __LINE__ <<

string Naming::TypeName(const string tag,bool glade) const
{  string ret(""),ctag=CName(tag);
   string::const_iterator i=ctag.begin();
   for (;i!=ctag.end() && *i=='_';++i) ret+=*i;
   if (i!=ctag.end()) ret+=toupper((unsigned char)*(i++));
   for (;i!=ctag.end();++i) ret+=*i;
   if (glade) ret+="_Glade";
   return ret;
}

string Naming::InstanceName(const string tag) const
{  string ret(""),ctag=CName(tag);
   string::const_iterator i=ctag.begin();
   for (;i!=ctag.end();++i) ret+=tolower((unsigned char)*i);
   return ret;
}

string Naming::RequireName(const string tag) const
{  string ret("_"),ctag=CName(tag);
   string::const_iterator i=ctag.begin();
   for (;i!=ctag.end();++i) ret+=toupper((unsigned char)*i);
   ret+="_REQUIRED";
   return ret;
}

string Naming::FileName(const string tag,File_type tp,int flags) const
{  string ret;

   if (!(flags&File_NODIR))
   {  ret=Configuration.destination_directory;
      if (ret.size() && ret[ret.size()-1]!='/') ret+='/';
   }
   switch(tp)
   {  case File_FOO_GLADE_HH:
         ret+=FName(tag);
   	 ret+="_glade.hh";
   	 break;
      case File_SUPPORT_HH: 
         ret+="glademm_support.hh";
         break;
      case File_SUPPORT_CC: 
         ret+="glademm_support";
         ret+=flags&File_OBJECT?".o":".cc";
         break;
      case File_FOO_HH:
      	 ret+=FName(tag);
         ret+=".hh";
         if ((flags&File_GLADE) || ((flags&File_NOREPLACE) && !access(ret.c_str(),F_OK)))
         {  ret+="_glade";
         }
         break;
      case File_FOO_GLADE_CC:
         ret+=FName(tag);
         ret+="_glade";
         ret+=flags&File_OBJECT?".o":".cc";
         break;
      case File_FOO_CC:
         ret+=FName(tag);
         ret+=flags&File_OBJECT?".o":".cc";
         if ((flags&File_GLADE) || ((flags&File_NOREPLACE) && !access(ret.c_str(),F_OK)))
         {  ret+="_glade";
         }
         break;
      case File_MAKEFILE:
      	 ret+="Makefile";
         if ((flags&File_GLADE) || ((flags&File_NOREPLACE) && !access(ret.c_str(),F_OK)))
         {  ret+="_glade";
         }
      	 break;
      case File_MAKEFILE_AM:
      	 ret+="Makefile.am";
         if ((flags&File_GLADE) || ((flags&File_NOREPLACE) && !access(ret.c_str(),F_OK)))
         {  ret+="_glade";
         }
      	 break;
      case File_CONFIGURE_IN:
      	 ret+="configure.in";
         if ((flags&File_GLADE) || ((flags&File_NOREPLACE) && !access(ret.c_str(),F_OK)))
         {  ret+="_glade";
         }
      	 break;
      case File_AUTOGEN_SH:
      	 ret+="autogen.sh";
         if ((flags&File_GLADE) || ((flags&File_NOREPLACE) && !access(ret.c_str(),F_OK)))
         {  ret+="_glade";
         }
      	 break;
      case File_MAIN_CC:
      	 ret+=Configuration.main_filename;
      	 ret+=flags&File_OBJECT?".o":".cc";
         if ((flags&File_GLADE) || ((flags&File_NOREPLACE) && !access(ret.c_str(),F_OK)))
         {  ret+="_glade";
         }
      	 break;
      default:
         cerr<<__FILELINE__" attempt to create unknown file type\n";
         ret+='?';
         break;
   }
   return ret;
}

string Naming::FileDefine(const string tag,File_type tp) const
{  string ret("_"),ctag=CName(tag);
   string::const_iterator i=ctag.begin();
   for (;i!=ctag.end();++i) ret+=toupper((unsigned char)*i);
   switch(tp)
   {  case File_FOO_GLADE_HH:
   	 ret+="_GLADE_HH";
   	 break;
      case File_FOO_HH:
         ret+="_HH";
         break;
      default:
         cerr << __FILELINE__" attempt to create unknown define type\n";
         break;
   }
   return ret;
}

string Naming::CName(const string tag) const throw()
{  string ret("");
   string::const_iterator i=tag.begin();
   // first char [_a-zA-Z]
   if (i!=tag.end()) 
   {  if (!(*i=='_' || isalpha((unsigned char)*i))) ret+='_';
      else ret+=*i;
      ++i;
   }
   // now [_a-zA-Z0-9]
   for (;i!=tag.end();++i) 
   {  if (!(*i=='_' || isalnum((unsigned char)*i))) ret+='_';
      else ret+=*i;
   }
   return ret;
}

string Naming::CString(const string x) const
{  string ret("");
   string::const_iterator i=x.begin();
   for (;i!=x.end();++i)
   {  switch((unsigned char)*i)
      {  case '"': ret+="\\\"";
            break;
         case '\\': ret+="\\\\";
            break;
         case '\n': ret+="\n\"\n\t\t\"";
            break;
         default: ret+=*i;
            break;
      }
   }
   return ret;
}

