/*  Gtk+ User Interface Builder
 *  Copyright (C) 1998  Damon Chaplin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifndef __LOAD_H__
#define __LOAD_H__

GbStatusCode load_project_file		(gchar *filename);

void        load_element		(GbWidgetSetArgData *data,
					 gint               *element,
					 gint               *cdata);
void        load_token			(GbWidgetSetArgData *data);
void	    load_token_skip_whitespace	(GbWidgetSetArgData *data);

void	    load_buffer_release		(GbWidgetSetArgData *data);


gchar*	    load_string			(GbWidgetSetArgData *data,
					 gchar		    *property_name);
gchar*	    load_text			(GbWidgetSetArgData *data,
					 gchar		    *property_name);
gint	    load_int			(GbWidgetSetArgData *data,
					 gchar		    *property_name);
gfloat	    load_float			(GbWidgetSetArgData *data,
					 gchar		    *property_name);
gboolean    load_bool			(GbWidgetSetArgData *data,
					 gchar		    *property_name);
gchar*	    load_choice			(GbWidgetSetArgData *data,
					 gchar		    *property_name);
gchar*	    load_combo			(GbWidgetSetArgData *data,
					 gchar		    *property_name);
guchar*	    load_color			(GbWidgetSetArgData *data,
					 gchar		    *property_name);
GdkPixmap*  load_bgpixmap		(GbWidgetSetArgData *data,
					 gchar		    *property_name,
					 gchar		   **filename);
gpointer    load_dialog			(GbWidgetSetArgData *data,
					 gchar		    *property_name);
gchar*	    load_filename		(GbWidgetSetArgData *data,
					 gchar		    *property_name);
GdkFont*    load_font			(GbWidgetSetArgData *data,
					 gchar		    *property_name,
					 gchar		   **xlfd_fontname);


gboolean    load_parse_bool		(GbWidgetSetArgData *data,
					 gchar		    *value);
guchar*     load_parse_color		(GbWidgetSetArgData *data,
					 gchar		    *value);

gchar*	    load_get_value		(GbWidgetSetArgData *data,
					 gchar		    *property_name);

#endif	/* __LOAD_H__ */
