
/*  Gtk+ User Interface Builder
 *  Copyright (C) 1998  Damon Chaplin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GLADE_MENU_EDITOR_H__
#define __GLADE_MENU_EDITOR_H__


#include <gdk/gdk.h>
#include <gtk/gtkwindow.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */


#define GLADE_MENU_EDITOR(obj)          GTK_CHECK_CAST (obj, glade_menu_editor_get_type (), GladeMenuEditor)
#define GLADE_MENU_EDITOR_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, glade_menu_editor_get_type (), GladeMenuEditorClass)
#define GLADE_IS_MENU_EDITOR(obj)       GTK_CHECK_TYPE (obj, glade_menu_editor_get_type ())


typedef struct _GladeMenuEditor       GladeMenuEditor;
typedef struct _GladeMenuEditorClass  GladeMenuEditorClass;

struct _GladeMenuEditor
{
  GtkWindow window;

  GtkWidget *clist;
  GtkWidget *label_label;
  GtkWidget *label_entry;
  GtkWidget *name_label;
  GtkWidget *name_entry;
  GtkWidget *handler_label;
  GtkWidget *handler_entry;
  GtkWidget *icon_label;
  GtkWidget *icon_entry;
  GtkWidget *icon_button;
  GtkWidget *type_frame;
  GtkWidget *normal_radiobutton;
  GtkWidget *check_radiobutton;
  GtkWidget *radio_radiobutton;
  GtkWidget *right_justify_label;
  GtkWidget *right_justify_togglebutton;
  GtkWidget *state_label;
  GtkWidget *state_togglebutton;
  GtkWidget *group_label;
  GtkWidget *group_combo;
  GtkWidget *accel_frame;
  GtkWidget *accel_key_entry;
  GtkWidget *accel_ctrl_checkbutton;
  GtkWidget *accel_shift_checkbutton;
  GtkWidget *accel_alt_checkbutton;
  GtkWidget *up_button;
  GtkWidget *down_button;
  GtkWidget *left_button;
  GtkWidget *right_button;
  GtkWidget *add_button;
  GtkWidget *delete_button;

  GtkWidget *ok_button;
  GtkWidget *apply_button;
  GtkWidget *cancel_button;
};

struct _GladeMenuEditorClass
{
  GtkWindowClass parent_class;
};


guint      glade_menu_editor_get_type    (void);
GtkWidget* glade_menu_editor_new         (void);

/* This sets the menubar/popup menu whose children are displayed in the
   menu editor, i.e. converted to items in the clist. */
void	   glade_menu_editor_set_menu	 (GladeMenuEditor *menued,
					  GtkMenuShell    *menu);

/* This updates the given widget, based on the settings in the menu editor.
   It removes all the current children of the menu and recreates it. */
void	   glade_menu_editor_update_menu (GladeMenuEditor *menued,
					  GtkMenuShell	  *menu);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GLADE_MENU_EDITOR_H__ */
