/*
Copyright (C) 1998-99 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

Generic Unix sub-include file for crtc.c

This file implements some of the functions, as described in crtdummy.h,
for a generic Unix system. It is meant to be included into other include
files for more specific Unix systems.

This library is free software; you can redistribute it and/or modify
it under the terms of the GNU Library General Public License as published by
the Free Software Foundation, version 2.

This library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA.
*/

#include <signal.h>
#include <sys/time.h>

/* Time for delayed updates in seconds----v and v----microseconds */
struct itimerval timerval = { { 0, 0 }, { 0, 100000 } };

void crt_alarm_handler (int sig);
void crt_alarm_handler (int sig)
{
  crt_update ();
}

struct sigaction crt_int_action, crt_term_action, crt_alarm_action, crt_winch_action;

static void crt_doupdate ()
{
  sigaction (SIGALRM, &crt_alarm_action, 0);
  setitimer (ITIMER_REAL, &timerval, 0);
}

static void crt_stop_update ()
{
  setitimer (ITIMER_REAL, 0, 0);
}

static void init_sigaction (struct sigaction *action, void (*handler)(int))
{
  action -> sa_handler = handler;
  memset (&action -> sa_mask, 0, sizeof (action -> sa_mask));
  action -> sa_flags = SA_RESTART;
}

static void crt_special_init1 ()
{
  init_sigaction (&crt_int_action,   &crt_int_handler);
  init_sigaction (&crt_term_action,  &crt_term_handler);
  init_sigaction (&crt_alarm_action, &crt_alarm_handler);
  init_sigaction (&crt_winch_action, &screen_size_changed);
  sigaction (SIGINT,   &crt_int_action,   0);
  sigaction (SIGTERM,  &crt_term_action,  0);
  sigaction (SIGWINCH, &crt_winch_action, 0);
}
