/*
Copyright (C) 1998-99 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

Dummy include file for crtc.c

The include files like crtdummy.h, crtunix.h, crtlinux386.h and crtdospc.h
contain those parts of CRT that cannot be done in a portable way.
These are 5 things:

- changing the screen size with TextMode,

- catching an INT (Ctrl-C) and/or TERM signal to have it treated by CRT,
  dependent on CheckBreak,

- playing sounds with Sound and NoSound,

- getting the keyboard shift state,

- refreshing the window promptly and fast.

All of these things are not crucial to CRT's operation, CRT will work
reasonably well without them. This file (crtdummy.h) provides dummy
functions that do nothing. It will be used on any system where no
special version exists.

To port this to a new system, do the following:

- copy the functions below to a new file,

- add an #include of that file, together with suitable #ifdefs, in crtc.c,

- fill in the functions as far as possible on the system.

The functions that can be implemented are:

special_crt_init():
any initialization the code here needs

special_crt_done():
any finalization the code here needs

crt_doupdate():
a function that can call crt_update(), either immediately, or delayed
(e.g. using a timer signal).
- calling crt_update() immerdiately (e.g. crtdospc.h): This is useful
  if curses' wrefresh() does not take a long time, like PDCurses under
  DJGPP which uses direct hardware access. The CRT window will then
  always be up to date. However, if wrefresh() takes a long time, this
  will slow down the program substantially.
- calling crt_update() delayed (e.g. crtlinux386.h): By using a timer,
  the number of calls to wrefresh() can be reduced so the program will
  not be slowed down too much. On the other hand, the timer guarantees
  that the window will not lag behind more than a specified amount of
  time. crt_update() is re-entrant, so the timer signal handler can call
  it without worries. Also, crt_doupdate() will not be called when there
  is a pending update (i.e. crt_doupdate() was called, but crt_update()
  was not called since then), so it can set the timer without worrying
  about disturbing a previously scheduled update.

crt_stop_update():
a function that is called before a Delay or is started, a child process
is executed, or the update level is changed, i.e. when a scheduled update
should not be done any more. If crt_doupdate() has set a timer, this
function must clear it, otherwise it might interfere with the Delay, so
e.g. Delay might get too short. crt_update() will be called after this
function, so the timer can safely be cleared without losing this update.

crt_settextmode():
a function that takes two boolean arguments, and sets the screen
to 40/80 columns and 25/50 (or 43) lines, depending on the arguments.
Afterwards, it must call screen_size_changed() with an arbitrary argument.

crt_getshiftstate():
a procedure that returns the keyboard shift state as a combination
of the shFoo constants, ORed with the value of the variable Shiftstate.

crt_sound():
a procedure that starts playing a sound of the given frequency, until
the next crt_sound() or crt_nosound() call

crt_nosound():
a procedure that stops playing the sound

crt_sound() and crt_nosound() are optional. If they are not provided, a
program that uses sound will fail with linking errors. That may be intended.
This file normally does not provide these functions. Only with a define
DUMMY_SOUND, it will implement empty functions, so programs using sound
will compile, but simply not play any sound.

To provide the CheckBreak capability, the code must arrange for
crt_int_handler() or crt_term_handler(), as declared in crtc.c, to be
called with an arbitrary argument, whenever an INT or TERM signal,
respectively, is received, and it must make sure that the program is not
aborted by the signal, and that no operation (especially reading from the
ncurses window) is disturbed by the signal.

crt_special_init(), crt_special_init(), crt_doupdate() and crt_stop_update()
can be static, crt_settextmode(), crt_sound() and crt_nosound() cannot be.

This library is free software; you can redistribute it and/or modify
it under the terms of the GNU Library General Public License as published by
the Free Software Foundation, version 2.

This library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA.
*/

static inline void crt_special_init ()
{
}

static inline void crt_special_done ()
{
}

static inline void crt_doupdate ()
{
  crt_update ();
}

static void crt_stop_update ()
{
}

void crt_settextmode (Boolean Columns40, Boolean Lines50)
{
}

int crt_getshiftstate ()
{
  return Shiftstate;
}

#ifdef DUMMY_SOUND
void crt_sound (unsigned Hz)
{
}

void crt_nosound ()
{
}
#endif
