{
Copyright (C) 1997-99 Free Software Foundation, Inc.

Authors: Bill Currie <bcurrie@tssc.co.nz>
         Frank Heckenbach <frank@pascal.gnu.de>

Implements the `Assign' procedure from Borland Pascal.

This file is part of GNU Pascal Library. The GNU Pascal Library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any
later version.

The GNU Pascal Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU Pascal Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.
}

unit FAssign;

interface

type
  AnyFile = Text; (*@@ create "AnyFile" parameters*)

  CFilePtr = Pointer;

{ bind a filename to an external file }
procedure Assign (var T : AnyFile; const Name : String);                           asmname '_p_assign';
procedure Internal_Assign (var T : AnyFile; Name : CString; NameLength : Integer); asmname '_p_internal_assign';
procedure Assign_CFile (var T : AnyFile; CFile : CFilePtr);                        asmname '_p_assign_cfile';

implementation

{$I-,B-} { I/O errors are passed back to the caller }

procedure Assign (var T : AnyFile; const Name : String);
var B : BindingType;
begin
  Unbind (T);
  B := Binding (T);
  B.Name := Name;
  B.Force := True;
  Bind (T, B)
end;

procedure Internal_Assign (var T : AnyFile; Name : CString; NameLength : Integer);
var
  B : BindingType;
  Buf : array [1 .. NameLength] of Char {$W-} absolute Name^; {$W+}
begin
  Unbind (T);
  B := Binding (T);
  B.Name := Buf;
  Bind (T, B)
end;

procedure Assign_CFile (var T : AnyFile; CFile : CFilePtr);
var B : BindingType;
begin
  Unbind (T);
  B := Binding (T);
  B.CFile := CFile;
  Bind (T, B)
end;

end.
