# Macros for GNU Pascal RTS autoconf script
# Copyright (C) 1995, 1996, 1997 Free Software Foundation, Inc.
# Contributed by J.J. van der Heijden (j.j.vanderheijden@student.utwente.nl).
#
# This file is part of GNU Pascal.
#
# GNU Pascal is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# GNU Pascal is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU Pascal; see the file COPYING.  If not, write to
# the Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

AC_DEFUN(GPC_BSD_RTS, [
#
# Enable BSD RTS only if
# (1) BSD style signals are supported
# (2) The user requested them (--with-bsd-rts)
#
AC_MSG_CHECKING(for BSD style RTS)
AC_ARG_WITH(bsdrts, [  --with-bsdrts           BSD style signals for RTS], with_bsdrts=${withval})
AC_CACHE_VAL(ac_cv_bsd_rts,[
# first check to see if --with-bsdrts was specified
if test x"${with_bsdrts}" != x ; then
  ac_cv_bsd_rts=${with_bsdrts}
fi
if test x"${with_bsdrts}" != x ; then
  # So you want BSD signals -- but what if you're really SYSV...
  AC_TRY_COMPILE([#include <signal.h>], [int i=SIGEMT;],
	ac_cv_bsd_rts=yes,
	ac_cv_bsd_rts=no)
  if test "${ac_cv_bsd_rts}" = "no"; then
    echo -n "detected SYSV ... "
  fi
else
  ac_cv_bsd_rts="no"
fi
])
AC_MSG_RESULT([${ac_cv_bsd_rts}])
if test "${ac_cv_bsd_rts}" = "yes"; then
  AC_DEFINE([BSD_RTS])
fi
])
