{
Copyright (C) 1998-99 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

Demo program for the GMP unit

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA.
}

program Factorial;

uses GPC, GMP;

var
  n : MedCard;
  f : mpz_t;
  s : CString;

begin
  case ParamCount of
    0 : begin
          Writeln ('Factorial computation.');
          Write ('Enter a number: ');
          Readln (n)
        end;
    1 : ReadStr (ParamStr (1), n);
    else
      Writeln (StdErr, 'Factorial computation.');
      Writeln (StdErr, 'Usage: ', ParamStr (0), ' [n]');
      Halt (1)
  end;
  mpz_init (f);
  mpz_fac_ui (f, n);
  s := mpz_get_str (nil, 10, f);
  {$X+} Writeln (n, '! = ', s); {$X-}
  Writeln ('(', StrLen (s), ' digits)');
  Dispose (s);
  mpz_clear (f)
end.
