/* tc.cxx
     $Id: tc.cxx,v 1.3 1998/09/07 00:49:37 elf Exp $

   written by Marc Singer
   21 December 1996

   This file is part of the project CurVeS.  See the file README for
   more information.

   Copyright (C) 1996,1997,1998 Marc Singer

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   in a file called COPYING along with this program; if not, write to
   the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA
   02139, USA.

   -----------
   DESCRIPTION
   -----------

*/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <malloc.h>

typedef struct {
  int type;
  int id;
  const char* sz;
} TERMINFO_FIELD;

#define __(t,i,s) { t, i, s },
TERMINFO_FIELD g_rgTerminfoField[] = {
# include "tc.d"
  { 0 }
#undef __
};

const char* name_field (int type, int id)
{
  for (TERMINFO_FIELD* pField = g_rgTerminfoField; pField->type; ++pField)
    if (pField->type == type && pField->id == id)
      return pField->sz;
  return NULL;
}

int main (int argc, char** argv)
{
  const char* szTerm = getenv ("TERM");
  if (argc > 1)
    szTerm = argv[1];

  char sz[200];
  sprintf (sz, "/usr/lib/terminfo/%c/%s", szTerm[0], szTerm);
  struct stat stat;
  if (::stat (sz, &stat)) {
    printf ("file '%s' not found\n", sz);
    exit (0);
  }
  long cb = stat.st_size;
  char* pb = (char*) malloc (cb + 1);
  pb[cb] = 0;

  int fh = open (sz, O_RDONLY);
  read (fh, pb, cb);
  close (fh);
  
  int cbName;
  int cBoolean;
  int cNum;
  int cStrings;
  int cbStrings;
  int cbHeader = 6*2;		// Size of header is just these six shorts
  printf ("Examining terminfo '%s'\n", sz);
  printf ("header:\n magic (0432, 282) %d\n"
	  " cbNames %d  cBoolean %d  cNum %d  cStrings %d  "
	  "cbStrings %d\n", 
	  pb[0] + pb[1]*256,
	  cbName = pb[2] + pb[3]*256,
	  cBoolean = pb[4] + pb[5]*256,
	  cNum = pb[6] + pb[7]*256,
	  cStrings = pb[8] + pb[9]*256,
	  cbStrings = pb[10] + pb[11]*256);
  printf ("name:\n '%s'\n", pb + cbHeader);

  int ibBoolean = cbHeader + cbName;
  int ibNum = ((ibBoolean + cBoolean + 1) & ~1);
  int ibStrings = ibNum + cNum*2;
  int ibStringTable = ibStrings + cStrings*2;

  printf ("offsets:\n"
	  " ibBoolean 0x%x  ibNum 0x%x  ibStrings 0x%x  ibStringTable 0x%x\n",
	  ibBoolean, ibNum, ibStrings, ibStringTable);

  for (int i = 0; i < cBoolean; ++i)
    printf ("bol %3d (%-20.20s): %s\n", i, name_field (1, i),
	    pb[ibBoolean + i] ? "true" : "false");

  for (int i = 0; i < cNum; ++i) {
    int value = pb[ibNum + i*2] + pb[ibNum + i*2 + 1]*256;
    printf ("num %3d (%-20.20s): %d (0x%x)\n", i, name_field (2, i),
	    value, value);
  }

  for (int i = 0; i < cStrings; ++i) {
    int ib = (unsigned char)  pb[ibStrings + i*2]
      | (unsigned) ((unsigned char) pb[ibStrings + i*2 + 1] << 8);
    char* sz;
    if ((ib & 0xffff) != 0xffff)
      sz = pb + ibStringTable + ib;
    else
      sz = NULL;
    if (sz == NULL)		// Enhancement to eliminate blank string items
      continue;
    printf ("str %3d (%-20.20s): %s", i, name_field (4, i),
	    sz ? "'" : "NULL");
    for (; sz && *sz; ++sz)
      if (*sz == 27)
	printf ("\\E");
      else if (*sz < 32 && *sz >= 0)
	printf ("^%c", *sz + '@');
      else if (*sz > 126 || *sz < 0)
	printf ("\\x%02x", unsigned (*sz & 0xff));
      else
	printf ("%c", *sz);
    printf ("%s\n", sz ? "'" : "");
  }

  free (pb);
  exit (0);
}
