/* bluet.cxx
     $Id: bluet.cxx,v 1.4 1998/09/07 00:49:32 elf Exp $

   written by Marc Singer
   22 February 1998

   Copyright (C) 1997 Marc Singer

   This file is part of the project CurVeS.  See the file README for
   more information.

   Copyright (C) 1997,1998 Marc Singer

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   in a file called COPYING along with this program; if not, write to
   the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA
   02139, USA.

   -----------
   DESCRIPTION
   -----------

*/

#include "std.h"
#include "blue6.h"
#include "preferences.h"

Termcap g_termcap;
char g_szProgram[1];		// For debug
extern int g_maskTrace;

void test1 (Window& window);
void test2 (Window& window);
void test3 (Window& window);
void test4 (Window& window);
void test5 (Window& window);
void test6 (Window& window);
void test7 (Window& window);

int main (int /* argc */, char** /* argv */)
{
  g_preferences.read (SZ_PATH_PREFERENCES);
  g_maskTrace = g_preferences.as_int ("Debug");
  g_termcap.init ();

  Window window;
  window.init (&g_termcap);

  test1 (window);
  test2 (window);
  window.move_to (Position (0, window.dy () - 1));
}

void test1 (Window& window)
{
  window.erase ();
  Pane pane (window, Rectangle (2, 2, 36, 3));

  pane.draw_text ("<-This is the top line of the Pane->"
		  "<-There are three lines total     ->"
		  "<-Press a key to erase middle text->");
  window.getch ();
  pane.erase (Rectangle (2, 1, 32, 1));
  window.getch ();
  window.draw_vertical_line (1, 2, 3);
  window.draw_vertical_line (38, 2, 3);
  window.getch ();
}

void test2 (Window& window)
{
  window.erase ();
  window.draw_text (Position (0, 0), "Test2");

  Pane pane (window, Rectangle (10, 10, window.dx () - 20, window.dy () - 20));
  pane.attrBg ().set (Attribute::BgRed);
  pane.erase ();

  //  window.draw_text (Position (10, window.dy () - 9), "Not red");
  window.getch ();
}


/*
;;; Local Variables: ***
;;; compile-command: "make -k bluet" ***
;;; End: ***
*/
