;;; -*- Mode: Lisp; Package: System -*-
;;;
;;; **********************************************************************
;;; This code was written as part of the CMU Common Lisp project at
;;; Carnegie Mellon University, and has been placed in the public domain.
;;; If you want to use this code or any part of CMU Common Lisp, please contact
;;; Scott Fahlman or slisp-group@cs.cmu.edu.
;;;
;(ext:file-comment
;  "$Header: config.lisp,v 1.4 93/07/26 15:16:03 ram Exp $")
;;;
;;; **********************************************************************
;;;
;;; Utility to load subsystems and save a new core.
;;;
(in-package "USER")


(block abort
  (let* ((output-file #-linux #p"library:nlisp.core"
		      #+linux #p"home:lisp.core")
	 (clm-present (not (not  (probe-file (make-pathname :defaults
							    "library:subsystems/clm-library"
							    :type
							    (c:backend-fasl-file-type c:*backend*))))))
		    
	 (clx-present (not (not  (probe-file (make-pathname :defaults
							    "library:subsystems/clx-library"
							    :type
							    (c:backend-fasl-file-type c:*backend*))))))
	 (clue-present (not (not  (probe-file (make-pathname :defaults
							     "library:subsystems/clue-library"
							     :type
							     (c:backend-fasl-file-type c:*backend*))))))
	 (clio-present (not (not  (probe-file (make-pathname :defaults
							     "library:subsystems/clio-library"
							     :type
							     (c:backend-fasl-file-type c:*backend*))))))
	 (pictures-present (not (not  (probe-file (make-pathname :defaults
								 "library:subsystems/pictures-library"
								 :type
								 (c:backend-fasl-file-type c:*backend*))))))
	 (hemlock-present (not (not  (probe-file (make-pathname :defaults
								"library:subsystems/hemlock-library"
								:type
								(c:backend-fasl-file-type c:*backend*))))))
	 (lisp-tk-present (not (not  (probe-file (make-pathname :defaults
								"library:subsystems/lisp-tk-library"
								:type
								(c:backend-fasl-file-type c:*backend*))))))
	 (defsystem-present (not (not  (probe-file (make-pathname :defaults
								  "library:subsystems/defsystem-library"
								  :type
								  (c:backend-fasl-file-type c:*backend*))))))
	 (series-present (not (not  (probe-file (make-pathname :defaults
							       "library:subsystems/series-library"
							       :type
							       (c:backend-fasl-file-type c:*backend*))))))
	 (f2cl-present (not (not  (probe-file (make-pathname :defaults
							     "library:subsystems/f2cl-library"
							     :type
							     (c:backend-fasl-file-type c:*backend*))))))
	 (cil-present (not (not  (probe-file (make-pathname :defaults
							    "library:subsystems/cil-library"
							    :type
							    (c:backend-fasl-file-type c:*backend*))))))
	 (tk-debugger-present (not (not  (probe-file (make-pathname :defaults
								    "library:subsystems/tk-debugger-library"
								    :type
								    (c:backend-fasl-file-type c:*backend*))))))
	 (quick-arrays-present (not (not  (probe-file (make-pathname :defaults
								     "library:subsystems/quick-arrays-library"
								     :type
								     (c:backend-fasl-file-type c:*backend*))))))
	 
	 (load-clm clm-present)
	 (load-clx clx-present)
	 (load-clue clue-present)
	 (load-clio clio-present)
	 (load-pictures pictures-present) 
	 (load-hemlock hemlock-present)
	 (load-lisp-tk nil)
	 (load-defsystem defsystem-present)
	 (load-series series-present)
	 (load-f2cl nil)
	 (load-cil nil)
	 (load-tk-debugger nil)
	 (load-quick-arrays quick-arrays-present)
	 (other ()))
    
    (loop
	(fresh-line)
	(format t " 1: specify result file (currently ~S)~%"
		(namestring output-file))
      (when clx-present
	(format t " 2: toggle loading of the CLX X library, currently ~
		 ~:[dis~;en~]abled.~%"
		load-clx))
      (when clue-present
	(format t " 3: toggle loading of the Clue library, currently ~
		 ~:[dis~;en~]abled. ~
                 ~:[~%    (would force loading of CLX)~;~]~%"
		load-clue load-clx))
      (when clio-present
	(format t " 4: toggle loading of the Clio library, currently ~
		 ~:[dis~;en~]abled. ~
                 ~:[~%    (would force loading of Clue)~;~] ~
                 ~:[~%    (would force loading of CLX)~;~]~%"
		load-clio load-clue load-clx))
      (when pictures-present
	(format t " 5: toggle loading of the Pictures library, currently ~
                 ~:[dis~;en~]abled. ~
                 ~:[~%    (would force loading of Clue)~;~] ~
                 ~:[~%    (would force loading of CLX)~;~]~%"
		load-pictures load-clue load-clx))
      (when clm-present
	(format t " 6: toggle loading of Motif and the graphical debugger, ~
		 currently ~:[dis~;en~]abled.~
		 ~:[~%    (would force loading of CLX.)~;~]~%"
		load-clm load-clx))
      (when hemlock-present
	(format t " 7: toggle loading the Hemlock editor, currently ~
		 ~:[dis~;en~]abled.~
		 ~:[~%    (would force loading of CLX.)~;~]~%"
		load-hemlock load-clx))
      (when lisp-tk-present
	(format t " 8: toggle loading of the Lisp-Tk library, currently ~
		 ~:[dis~;en~]abled.~%"
		load-lisp-tk))
      (when defsystem-present
	(format t " 9: toggle loading of the defsystem library, currently ~
		 ~:[dis~;en~]abled.~%"
		load-defsystem))
      (when series-present
	(format t "10: toggle loading of the series library, currently ~
                 ~:[dis~;en~]abled.~%"
		load-series))
      (when f2cl-present
	(format t "11: toggle loading of the f2cl library, currently ~
                 ~:[dis~;en~]abled.~%"
		load-f2cl))
      (when cil-present
	(format t "12: toggle loading of the Cil (chess) library, currently ~
                 ~:[dis~;en~]abled. ~%"
		load-cil))
      (when tk-debugger-present
	(format t "13: toggle loading of the Tk-debugger (lisp-debug 0.5) library, currently ~
                 ~:[dis~;en~]abled. ~
                 ~:[~%    (would force loading of Tk)~;~]~%"
		load-tk-debugger load-lisp-tk))
      (when quick-arrays-present
	(format t "14: toggle loading of the Quick-arrays library, currently ~
                 ~:[dis~;en~]abled. ~%"
		load-quick-arrays))

      (format t " 90: specify some site-specific file to load.~@
		 ~@[    Current files:~%~{      ~S~%~}~]"
	      (mapcar #'namestring other))
      (format t " 99: configure according to current options.~%")
      (format t " 0: abort the configuration process.~%")
      (format t "~%Option number: ")
      (force-output)
      (flet ((file-prompt (prompt)
	       (format t prompt)
	       (force-output)
	       (pathname (string-trim " 	" (read-line)))))
	(let ((res (ignore-errors (read-from-string (read-line)))))
	  (case res
	    (1
	     (setq output-file (file-prompt "Result core file name: ")))
	    (2
	     (when clx-present
	       (unless (setq load-clx (not load-clx))
		 (progn
		   (setq load-hemlock nil)
		   (setq load-pictures nil)
		   (setq load-clio nil)
		   (setq load-clue nil)))))
	    (3
	     (when clue-present
	       (if (setq load-clue (not load-clue))
		   (setq load-clx t)
		 (progn
		   (setq load-clio nil)
		   (setq load-pictures nil)))))
	    (4	     
	     (when clio-present
	       (setq load-clio (not load-clio))
	       (when load-clio
		 (setq load-clue t)
		 (setq load-clx t))))
            (5
	     (when pictures-present
	       (setq load-pictures (not load-pictures))
	       (when load-pictures
		 (setq load-clue t)
		 (setq load-clx t))))
	    (6
	     (when clm-present
	       (when (setq load-clm (not load-clm))
		 (setq load-clx t))))
	    (7
	     (when hemlock-present
	       (when (setq load-hemlock (not load-hemlock))
		 (setq load-clx t))))
	    (8 (when lisp-tk-present
		 (setq load-lisp-tk (not load-lisp-tk))))
	    (9 (when defsystem-present
		 (setq load-defsystem (not load-defsystem))))
            (10 (when series-present
		  (setq load-series (not load-series))))
            (11 (when f2cl-present
		  (setq load-f2cl (not load-f2cl))))
	    (12 (when cil-present
		  (setq load-cil (not load-cil))))
	    (13 (when tk-debugger-present
		  (when (setq load-tk-debugger (not load-tk-debugger ))
		    (setq load-lisp-tk t))))
	    (14 (when quick-arrays-present 
		  (setq load-quick-arrays (not load-quick-arrays))))
	    (90
	     (setq other
		   (append other
			   (list (file-prompt "File(s) to load ~
					       (can have wildcards): ")))))

	    (99 (return))
	    (0
	     (format t "~%Aborted.~%")
	     (return-from abort))))))
    
    (gc-off)
    (when load-clx
      (setf *features* (delete :no-clx *features* :test #'eq))
      (load "library:subsystems/clx-library"))
    (when load-clue
      (setf *features* (delete :no-clue *features* :test #'eq))
      (setf (getf ext:*herald-items* :clue)
	    `("    Clue Library 1"))
      (load "library:subsystems/clue-library"))
    (when load-clio
      (setf *features* (delete :no-clio *features* :test #'eq))
      (pushnew :clio *features*)
      (setf (getf ext:*herald-items* :clio)
	    `("    Clio Library 1"))
      (load "library:subsystems/clio-library"))
    (when load-pictures
      (setf *features* (delete :no-pictures *features* :test #'eq))
      (pushnew :pictures *features*)
      (setf (getf ext:*herald-items* :pictures)
	    `("    Pictures Library 1"))
      (load "library:subsystems/pictures-library"))
    (when load-clm
      (setf *features* (delete :no-clm *features* :test #'eq))
      (load "library:subsystems/clm-library"))
    (when load-hemlock
      (setf *features* (delete :no-hemlock *features* :test #'eq))
      (load "library:subsystems/hemlock-library"))
    (when load-lisp-tk
      (setf *features* (delete :no-lisp-tk *features* :test #'eq))
      (setf (getf ext:*herald-items* :clue)
	    `("    Lisp-Tk 0.1"))
      (load "library:subsystems/lisp-tk-library"))

    (when load-defsystem
      (setf (getf ext:*herald-items* :defsystem)
	    `("    Defsystem Mar 13 1995"))
      (load "library:subsystems/defsystem-library"))
    
    (when load-series
      (setf (getf ext:*herald-items* :series)
            `("    Series 1.0"))
      (load "library:subsystems/series-library"))

    (when load-f2cl
      (setf (getf ext:*herald-items* :f2cl)
            `("    f2cl 1.0"))
      (load "library:subsystems/f2cl-library"))
    (when load-cil
      (setf (getf ext:*herald-items* :cil)
            `("    Chess In Lisp 1997.06.08"))
      (load "library:subsystems/cil-library"))
    (when load-tk-debugger
      (setf (getf ext:*herald-items* :tk-debugger)
	    `("    Lisp-debug 0.5"))
      (load "library:subsystems/tk-debugger-library"))
    (when load-quick-arrays
      (setf (getf ext:*herald-items* :quick-arrays)
	    `("    Quick Arrays 1.0"))
      (load "library:subsystems/quick-arrays-library"))
  
    (dolist (f other) (load f))
    
    (setq *info-environment*
	  (list* (make-info-environment :name "Working")
		 (compact-info-environment (first *info-environment*)
					   :name "Auxiliary")
		 (rest *info-environment*)))
    
    (when (probe-file output-file)
      (multiple-value-bind
	    (ignore old new)
	  (rename-file output-file
		       (concatenate 'string (namestring output-file)
				    ".BAK"))
	(declare (ignore ignore))
	(format t "~&Saved ~S as ~S.~%" (namestring old) (namestring new))))
    
    ;;
    ;; Enable the garbage collector.  But first fake it into thinking that
    ;; we don't need to garbage collect.  The save-lisp is going to call
    ;; purify so any garbage will be collected then.
    #-gengc (setf lisp::*need-to-collect-garbage* nil)
    (gc-on)
    ;;
    ;; Save the lisp.
    (save-lisp output-file)))

(quit)
