/*
    read_temp: a sample program to read temperature of Netwinder Rev4+
    Copyright 1998  woody@corelcomputer.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <errno.h>

#include "therm.h"



main(argc,argv)
     int argc;
     char **argv;
{

	int	fd = 0;
	int	uTemp = 0;
	int	uTemp1 = 0;
	char*	basename;
	char* 	p;
	
//	printf("\nargc=%d, argv:[0]=%s, [1]=%s.\n\n",
//	    argc,argv[0],argv[1]);
	
	basename = (p = strrchr(argv[0], '/')) ? p+1 : argv[0];
    
	if(argc != 1)
	{
	        fprintf(stderr,"\nNetWinder Temperature read program, Corel Computer 1998.\n\n",
	        basename);
	    return -1;
	}
	  
	fd = open("/dev/temperature", O_RDONLY);
	if (fd <0)
	{
		printf("Error %d opening /dev/temperature\n",fd);
		return;
	}
	else
	{
//		printf("/dev/temperature open OK, rc = 0x%X.\n",fd);
	}

//	This is an old (1 degree precision) IOCTL call
//	ioctl(fd, CMD_GET_TEMPERATURE, &uTemp1);

	ioctl(fd, CMD_GET_TEMPERATURE2, &uTemp1);

	ioctl(fd, CMD_GET_STATUS, &uTemp);
        printf("Current temperature reading %d.%d, status 0x%02X...\n",
		uTemp1>>1, (uTemp1&1)?5:0, uTemp);

	if (close(fd) != 0)
		printf("Error closing /dev/temperature\n");
}

