package Test;
require 5.002;
use strict;

my @tv = (
# test flags		input		expected output	expected return code
#
['1', '-d: -f1,3-',	"a:b:c\n",		"a:c\n",		0],
['2', '-d: -f1,3-',	"a:b:c\n",		"a:c\n",		0],
['3', '-d: -f2-',	"a:b:c\n",		"b:c\n",		0],
['4', '-d: -f4',	"a:b:c\n",		"\n",			0],
['5', '-d: -f4',	"",			"",			0],
['6', '-c4',		"123\n",		"\n",			0],
['7', '-c4',		"123",			"\n",			0],
['8', '-c4',		"123\n1",		"\n\n",			0],
['9', '-c4',		"",			"",			0],
['a', '-s -d: -f3-',	"a:b:c\n",		"c\n",			0],
['b', '-s -d: -f2,3',	"a:b:c\n",		"b:c\n",		0],
['c', '-s -d: -f1,3',	"a:b:c\n",		"a:c\n",		0],
# Trailing colon should not be output
['d', '-s -d: -f1,3',	"a:b:c:\n",		"a:c\n",		0],
['e', '-s -d: -f3-',	"a:b:c:\n",		"c:\n",			0],
['f', '-s -d: -f3-4',	"a:b:c:\n",		"c:\n",			0],
['g', '-s -d: -f3,4',	"a:b:c:\n",		"c:\n",			0],
# Make sure -s suppresses non-delimited lines
['h', '-s -d: -f2,3',	"abc\n",		"",			0],
#
['i', '-d: -f1-3',	":::\n",		"::\n",			0],
['j', '-d: -f1-4',	":::\n",		":::\n",		0],
['k', '-d: -f2-3',	":::\n",		":\n",			0],
['l', '-d: -f2-4',	":::\n",		"::\n",			0],
['m', '-s -d: -f1-3',	":::\n",		"::\n",			0],
['n', '-s -d: -f1-4',	":::\n",		":::\n",		0],
['o', '-s -d: -f2-3',	":::\n",		":\n",			0],
['p', '-s -d: -f2-4',	":::\n",		"::\n",			0],
['q', '-s -d: -f2-4',	":::\n:\n",		"::\n\n",		0],
['r', '-s -d: -f2-4',	":::\n:1\n",		"::\n1\n",		0],
['s', '-s -d: -f1-4',	":::\n:a\n",		":::\n:a\n",		0],
['t', '-s -d: -f3-',	":::\n:1\n",		":\n\n",		0],
# Make sure it handles empty input properly, with and without -s.
['u', '-s -f3-',	"",			"",			0],
['v', '-f3-',		"",			"",			0],
# Make sure it handles empty input properly.
['w', '-b 1',		"",			"",			0],
['x', '-s -d: -f2-4',	":\n",			"\n",			0],
# Errors
# -s may be used only with -f
['y', '-s -b4',		":\n",			"",			1],
# You must specify bytes or fields (or chars)
['z', '',		":\n",			"",			1],
# Empty field list
['empty-fl', '-f \'\'',	":\n",			"",			1],
# Missing field list
['missing-fl', '-f',	":\n",			"",			1],
# Empty byte list
['empty-bl', '-b \'\'',	":\n",			"",			1],
# Missing byte list
['missing-bl', '-b',	":\n",			"",			1],
);

sub test_vector
{
  return @tv;
}

1;
