#define _GNU_SOURCE
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>

/* This program has been hacked slightly to not call the usual libc
   initialisation code, because it doesn't need it and doing this saves
   a lot of space because it will be linked statically.  */

asm ("\
	.section \".text\"
	.align 2
	.globl _start
	.type _start,@function
_start:
 # save the stack pointer, in case we're statically linked under Linux
	mr 8,1
 # set up an initial stack frame, and clear the LR
	addi 1,1,-16
	clrrwi 1,1,4
	li 0,0
	stw 0,0(1)
	mtlr 0
 # set r13 to point at the 'small data area'
	lis 13,_SDA_BASE_@ha
	addi 13,13,_SDA_BASE_@l
 # and continue below.
	b __start1
0:
	.size	 _start,0b-_start
 # undo '.section text'.
	.previous
");

#define put_string(x) write(STDOUT_FILENO, x, strlen(x))
#define put_error(x) write(STDERR_FILENO, x, strlen(x))

int
main(int argc, char **argv)
{
  int c;
  size_t i, ct;

  if (argc != 3
      || strcmp(argv[1],"--help") == 0
      || strcmp(argv[2],"--help") == 0)
    {
      put_string ("Usage: ");
      put_string (argv[0]);
      put_string (" SOURCE DESTINATION\n"
	    "Rename SOURCE to DESTINATION, in one simple system call.\n");
      return 0;
    }
  if (rename(argv[1],argv[2]) != 0)
    {
      put_error(argv[0]);
      put_error(": ");
      put_error(sys_errlist[errno]);
      put_error(".\n");
      return 1;
    }
  return 0;
}

void
__start1(int argc, char **argv, char **envp,
	 void *auxvec, void (*exitfn) (void),
	 char **stack_on_entry)
{
  /* the PPC SVR4 ABI says that the top thing on the stack will
     be a NULL pointer, so if not we assume that we're being called
     as a statically-linked program by Linux...	 */
  if (*stack_on_entry != NULL)
    {
      /* ...in which case, we have argc as the top thing on the
	 stack, followed by argv (NULL-terminated), envp (likewise),
	 and the auxilary vector.  */
      argc = *(int *) stack_on_entry;
      argv = stack_on_entry + 1;
    }

  /* the rest of the program */
  _exit (main (argc, argv));
}
