#ifndef aboot_h
#define aboot_h

#include <stdarg.h>

#include <asm/hwrpb.h>

#include <setjmp.h>


#define SECT_SIZE	512	/* console block size for disk reads */
#define BOOT_SECTOR	2	/* first sector of 2ndary bootstrap loader */


extern struct bootfs *	bfs;
extern char *		dest_addr;
extern long		bytes_to_copy;
extern jmp_buf		jump_buffer;

extern long		config_file_partition;

extern char		boot_file[256];
extern char		kernel_args[256];
extern unsigned long	start_addr;
extern char *		bss_start;
extern long		bss_size;

extern long		first_block (const char *buf, long blocksize);
extern unsigned long	switch_to_osf_pal (unsigned long nr,
					   struct pcb_struct *pcb_va,
					   struct pcb_struct *pcb_pa,
					   unsigned long vptb,
					   unsigned long *kstk);
extern int		uncompress_kernel (int fd);
extern int		vsprintf (char *, const char *, va_list);

#endif /* aboot_h */
