# copyright (C) 1997-98 Jean-Luc Fontaine (mailto:jfontain@mygale.org)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: utility.tcl,v 1.4 1998/09/18 21:18:30 jfontain Exp $}

proc minimum {a b} {return [expr {$a<$b?$a:$b}]}
proc maximum {a b} {return [expr {$a>$b?$a:$b}]}

proc ldelete {listName value} {
    upvar $listName list

    set index [lsearch -exact $list $value]
    if {$index<0} {
        error "\"$value\" is not in list"
    }
    set list [lreplace $list $index $index]

}

proc startGatheringRCSIds {} {
    trace variable ::rcsId w recordRCSId
}

proc recordRCSId {variableName empty operation} {
    foreach {header file version} $::rcsId break
    regsub {,v$} $file {} file
    set ::sourceVersion($file) $version
}
