/*
 * $Id: snmp_lib.h,v 1.6 1998/09/28 17:58:29 gregm Exp $
 * GXSNMP -- An snmp management application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * Defines and variables for snmp support
 */
#ifndef __SNMP_IO_H__
#define __SNMP_IO_H__
#include <glib.h>
#include <g_snmp.h>

#define MAX_DGRAM_SIZE 32768
/*
 * Type of oid_entries for query to a node.
 */
enum {
  OID_UPDATE_WIDGET,
  OID_UPDATE_VARIABLE
};

struct oid_entry {
  gint     oe_type;
  gchar    oe_name;           /* The textual representation of the oid */
  gulong   oe_id [SNMP_SIZE_OBJECTID];
  gint     oe_idlen;
  gpointer oe_update;         /* a pointer to the widget or variable to
				 update */
};

typedef struct oid_entry oid_entry;

void           snmp_input_cb           (gpointer          data, 
					gint              source, 
					GdkInputCondition condition);
void           snmpinit                ();

void           snmp_add_null_var       (GSList            **objs,
					GSList            **entry,
					gchar             *what,
					gchar             *identifier,
					gint              upd_type,
					gpointer          update);
gboolean       snmp_update_func        (host_snmp         *host,
					gpointer          magic,
					SNMP_PDU          *spdu,
					GSList            *objs);

#endif
/* EOF */
