/*
 * $Id: plugins.h,v 1.2 1998/09/28 17:58:25 gregm Exp $
 * GXSNMP -- An snmp management application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * plugin.h -- Plugin handling code.
 */

#ifndef __PLUGIN_H__
#define __PLUGIN_H__

/*
 * Shamelessly copied from gnumeric :)
 */
#include <gmodule.h>
#include <gtk/gtk.h>

struct PluginData
{
  GModule  *handle;
  int      (*init_plugin)    (struct PluginData *);
  void     (*cleanup_plugin) (struct PluginData *);
  int      refcount;
  gchar    *title;

  /* Filled in by the plugin */
  void     *private;
};

/*
 * Proposed API for the plugins.
 * pf_type  : Type of function that this plugin provides.
 * pf_argc  : The number of args it accepts
 * pf_argv  : The actual arg/value pairs
 * pf_func  : The function to call
 */
struct PluginFuncs
{
  gint     pf_type;              /* What type of function is this */
  gint     pf_argc;              /* argument count */
  gchar    *pf_argv;             /* Argument pairs */
  void     (*pf_func) ();
};

typedef struct PluginData     PluginData;
typedef struct PluginFuncs    PluginFuncs;

extern GList *plugin_list;

/*
 * Functions for this Module 
 */

void              plugins_init             (void);
PluginData        *plugin_load             (gchar       *filename);
void              plugin_unload            (PluginData  *pd);

/*
 * These are the minimal functions that need to be defined in the plugin.
 */

int               init_plugin              (PluginData  *pd);
void              cleanup_plugin           (PluginData  *pd);

#endif

/* EOF */

