
/*
 * $Id: main_panel.c,v 1.22 1998/09/28 17:58:20 gregm Exp $
 * GXSNMP -- An snmp mangament application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * Main panel code. (actually the 'control panel' of sorts
 */

#include "main.h"
#include "gui.h"
#include "protos.h"

/*
 * Forward declarations
 */
static gint            panel_delete_cb        (GtkWidget  *widget,
				               GdkEvent   *e,
				               gpointer   data);
static void            create_panel           (void);
/*
 * Menu callback functions (really just wrappers to the real functions)
 */
static void            about_cb               (GtkWidget  *widget,
					       gpointer   data);
static void            host_cb                (GtkWidget  *widget,
					       gpointer   data);
static void            network_cb             (GtkWidget  *widget,
					       gpointer   data);
static void            m_browser_cb           (GtkWidget  *widget,
					       gpointer   data);
static void            rmon_cb                (GtkWidget  *widget,
					       gpointer   data);
static void            events_cb              (GtkWidget  *widget,
					       gpointer   data);
static void            quit_cb                (GtkWidget  *widget,
					       gpointer   data);
static void            close_cb               (GtkWidget  *widget,
					       gpointer   data);
static void            config_cb              (GtkWidget  *widget,
					       gpointer   data);
static void            add_cb                 (GtkWidget  *widget,
					       gpointer   data);
static void            delete_cb              (GtkWidget  *widget,
					       gpointer   data);
static void            snmp_menu_set          (GtkWidget  *widget,
					       gpointer   data);
static void            snmp_menu_get          (GtkWidget  *widget,
					       gpointer   data);
static void            snmp_menu_monitor      (GtkWidget  *widget,
					       gpointer   data);
static void            net_add_menu_cb        (GtkWidget  *widget,
					       gpointer   data);
static void            net_del_menu_cb        (GtkWidget  *widget,
					       gpointer   data);
/*
 * Local variables
 */
static GtkWidget     *window;
static GtkWidget     *widgets[5];

static char *cont_labels[] = {
  N_("Known Hosts"),
  N_("Known Networks"),
  N_("Outstanding Alarms"),
  N_("Pending events"),
  N_("Pending Tasks")
};

static GnomeUIInfo file_menu[] = {
  { GNOME_APP_UI_ITEM, N_("Close"), NULL, close_cb, NULL, NULL, 
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Exit"), NULL, quit_cb, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXIT, 'X', GDK_CONTROL_MASK,
    NULL },
  { GNOME_APP_UI_ENDOFINFO }
};

static GnomeUIInfo edit_menu[] = {
  { GNOME_APP_UI_ITEM, N_("Configuration"), NULL, config_cb, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF, 'C', GDK_MOD1_MASK,
    NULL },
  { GNOME_APP_UI_ENDOFINFO }
};

static GnomeUIInfo tools_menu[] = {
  { GNOME_APP_UI_ITEM, N_("Add host..."), NULL, add_cb, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 'A', GDK_MOD1_MASK,
    NULL },
  { GNOME_APP_UI_ITEM, N_("Delete Host..."), NULL, delete_cb, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 'D', GDK_MOD1_MASK,
    NULL },
  { GNOME_APP_UI_ITEM, N_("Add Network..."), NULL, net_add_menu_cb, NULL,
    NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Delete Network..."), NULL, net_del_menu_cb, NULL, 
    NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0, 0, NULL },
  { GNOME_APP_UI_ENDOFINFO }
};

static GnomeUIInfo window_menu[] = {
  { GNOME_APP_UI_ITEM, N_("Host List..."), NULL, host_cb, NULL, NULL, 
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 'L', GDK_MOD1_MASK,
    NULL },
  { GNOME_APP_UI_ITEM, N_("Network List..."), NULL, network_cb, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 'N', GDK_MOD1_MASK,
    NULL },
  { GNOME_APP_UI_ITEM, N_("Mib Browser..."), NULL, m_browser_cb, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 'B', GDK_MOD1_MASK,
    NULL },
  { GNOME_APP_UI_ITEM, N_("RMON..."), NULL, rmon_cb, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 'R', GDK_MOD1_MASK,
    NULL },
  { GNOME_APP_UI_ITEM, N_("Events List..."), NULL, events_cb, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 'V', GDK_MOD1_MASK,
    NULL },
  { GNOME_APP_UI_ENDOFINFO }
};

static GnomeUIInfo util_menu[] = {
  { GNOME_APP_UI_ITEM, N_("Mib Editor..."), NULL, NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 'M', GDK_MOD1_MASK,
    NULL },
  { GNOME_APP_UI_ENDOFINFO }
};
static GnomeUIInfo snmp_menu[] = {
  { GNOME_APP_UI_ITEM, N_("SNMP Set..."), NULL, snmp_menu_set, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("SNMP Get..."), NULL, snmp_menu_get, NULL, NULL, 
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Monitor Mib..."), NULL, snmp_menu_monitor, NULL,
    NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0, 0, NULL},
  { GNOME_APP_UI_ENDOFINFO }
};

static GnomeUIInfo help_menu[] = {
  { GNOME_APP_UI_HELP, NULL, NULL, NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("About..."), NULL, about_cb, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT, 'A', GDK_CONTROL_MASK,
    NULL },
  { GNOME_APP_UI_ENDOFINFO }
};

static GnomeUIInfo gxsnmp_menu[] = {
  { GNOME_APP_UI_SUBTREE, N_("File"), NULL, file_menu, NULL, NULL, 
    GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
  { GNOME_APP_UI_SUBTREE, N_("Edit"), NULL, edit_menu, NULL, NULL, 
    GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
  { GNOME_APP_UI_SUBTREE, N_("Tools"), NULL, tools_menu, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
  { GNOME_APP_UI_SUBTREE, N_("Windows"), NULL, window_menu, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
  { GNOME_APP_UI_SUBTREE, N_("Utilities"), NULL, util_menu, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
  { GNOME_APP_UI_SUBTREE, N_("SNMP Functions"), NULL, snmp_menu, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
  { GNOME_APP_UI_SUBTREE, N_("Help"), NULL, help_menu, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
  { GNOME_APP_UI_ENDOFINFO }
};

static GTCallbacks button_info[] = {
  { GT_BUTTON_CLOSE, close_cb, NULL, "close_button" },
  { GT_BUTTON_EXIT, quit_cb, NULL, "quit_button" },
  { GT_UI_END, NULL, NULL, NULL }
};

/* 
 * Global variables 
 */

/*
 * Imported variables
 */
extern gxsnmp *app_info;
/*
 * Local functions
 */
static void
create_panel ()
{
  GtkWidget        *vbox;
  GtkWidget        *bar;
  GtkWidget        *bbox;
  GtkWidget        *frame;
  GtkWidget        *label;
  GtkWidget        *table;
  int              i;

  window = gnome_app_new ("GXSNMP", _("GXSNMP"));
  gtk_window_set_wmclass (GTK_WINDOW (window), "control_window",
			  "GXSNMP");
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      GTK_SIGNAL_FUNC (panel_delete_cb),
		      NULL);
  vbox = gtk_vbox_new (FALSE, 0);

  bar = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (vbox), bar, TRUE, TRUE, 0);
  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, TRUE, TRUE, 0);
  table = gtk_table_new (ELEMENTS (cont_labels), 2, TRUE);
  gtk_container_border_width (GTK_CONTAINER (table), 2);
  gtk_container_add (GTK_CONTAINER (frame), table);
  for ( i = 0; i < ELEMENTS (cont_labels); i++)
    {
      label = gtk_label_new (gettext(cont_labels[i]));
      gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
      gtk_table_attach (GTK_TABLE (table), label, 0, 1, i, (i + 1),
			GTK_FILL | GTK_SHRINK,  GTK_SHRINK, 2, 1);
      widgets[i] = gtk_entry_new ();
      gtk_table_attach (GTK_TABLE (table), widgets[i], 
			1, 2, i, (i + 1),
			GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_SHRINK,
			2, 1);
    }

  /* Top Frame */
  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, TRUE, TRUE, 0);
  bbox = gtk_hbutton_box_new ();
  gtk_container_border_width (GTK_CONTAINER (bbox), 2);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (bbox), 3);
  gtk_button_box_set_child_size (GTK_BUTTON_BOX (bbox), 85, 20);
  gtk_container_add (GTK_CONTAINER (frame), bbox);
  gt_add_action_buttons (button_info, bbox);
  /*
   * Set the gnome app specific stuff
   */
  gnome_app_set_contents (GNOME_APP (window), vbox);
  gnome_app_create_menus (GNOME_APP (window), gxsnmp_menu);
  gtk_menu_item_right_justify (GTK_MENU_ITEM (gxsnmp_menu[6].widget));
  gtk_widget_show_all (window);
}

static gint
panel_delete_cb (GtkWidget *widget, GdkEvent *e, gpointer data)
{
  gtk_widget_destroy (window);
  return TRUE;
}

/*
 * The callback wrapper functions
 */
static void
about_cb (GtkWidget *widget, gpointer data)
{
  open_about_panel ();
}

static void
host_cb (GtkWidget *widget, gpointer data)
{
  hlist_panel_open ();
}

static void
network_cb (GtkWidget *widget, gpointer data)
{
  open_network_panel ();
}

static void
m_browser_cb (GtkWidget *widget, gpointer data)
{
  open_browser_panel ();
}

static void
rmon_cb (GtkWidget *widget, gpointer data)
{
  open_rmon_panel ();
}

static void
events_cb (GtkWidget *widget, gpointer data)
{
  open_event_panel ();
}

static void
quit_cb (GtkWidget *widget, gpointer data)
{
  quit_app ();
}

static void
close_cb (GtkWidget *widget, gpointer data)
{
  hide_control_panel ();
}

static void
config_cb (GtkWidget *widget, gpointer data)
{
  open_config_panel ();
}

static void
add_cb (GtkWidget *widget, gpointer data)
{
  open_add_host_panel ();
}

static void
delete_cb (GtkWidget *widget, gpointer data)
{
  /* Needs to be connected/re-designed slightly */
}

static void
snmp_menu_set (GtkWidget *widget, gpointer data)
{
  open_set_panel ();
}

static void
snmp_menu_get (GtkWidget *widget, gpointer data)
{
  open_get_panel ();
}

static void 
snmp_menu_monitor (GtkWidget *widget, gpointer data)
{
  open_monitor_panel ();
}

static void
net_add_menu_cb (GtkWidget *widget, gpointer data)
{
  open_add_network_panel ();
}

static void
net_del_menu_cb (GtkWidget *widget, gpointer data)
{
  /* needs to be written */
}

/*
 * Global functions
 */
void 
open_control_panel ()
{
  if (window == NULL)
    {
      create_panel ();
    }
  else if (!GTK_WIDGET_VISIBLE (window))
    {
      gtk_widget_show (window);
    }
  reset_control_panel ();
}

void
destroy_control_panel ()
{
  if (window != NULL)
    {
      gtk_widget_destroy (window);
      window = NULL;
    }
}

void
hide_control_panel ()
{
  if (window)
      if (GTK_WIDGET_VISIBLE (window))
	gtk_widget_hide (window);
}

void reset_control_panel ()
{
  update_known_hosts (app_info->host_count);
  update_known_networks (app_info->network_count);
}

/*
 * Misc functions related to the main panel.
 */
void
update_known_hosts (int i)
{
  char    buf[256];

  snprintf (buf, sizeof(buf), "%i", i);
  gtk_entry_set_text (GTK_ENTRY (widgets[CONTROL_KNOWN_HOSTS]), buf);
}

void
update_known_networks (int i)
{
  char    buf[256];

  snprintf (buf, sizeof(buf), "%i", i);
  gtk_entry_set_text (GTK_ENTRY (widgets[CONTROL_KNOWN_NETWK]), buf);
}

/* EOF */
