/*
 * $Id: main.c,v 1.57 1998/09/29 21:42:42 gregm Exp $
 * GXSNMP -- An snmp mangament application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * Main program entry point
 * Also the main panel code is here.
 */
#include <config.h>
#include "main.h"
#include <gtkhost.h>
#include "net_map.h"
#include "protos.h"
#include "plugins.h"

/*
 * Local functions 
 */
static void quit_button_cb      (GtkWidget *widget,
				 gpointer  data);
static gint panel_delete_cb     (GtkWidget *widget,
				 GdkEvent  *e,
				 gpointer  data);
gint draw_host                  (GtkWidget *widget,
				 hosts *hentry);

gxsnmp *app_info;

#define FILE_MENU_NEW    1
#define FILE_MENU_OPEN   2
#define FILE_MENU_SAVE   3
#define FILE_MENU_SAVEAS 4
#define FILE_MENU_QUIT   5
#define EDIT_MENU_COPY   6
#define EDIT_MENU_CUT    7
#define EDIT_MENU_CONFIG 8
#define TOOL_MENU_ADDH   9
#define TOOL_MENU_DELH   10
#define TOOL_MENU_HOSTL  11
#define TOOL_MENU_NETL   12
#define TOOL_MENU_MIBB   13
#define TOOL_MENU_EVENT  14
#define HELP_ABOUT_ITEM  15

typedef struct __MyMenu {
  char *text;
  int  code;
  char *accel;
  gpointer callback;
} MyMenu;

void
quit_app ()
{
  quit_button_cb (NULL, NULL);
}

/*
 * The callback functions
 */

static void
quit_button_cb (GtkWidget *widget,
		gpointer  data)
{

  close_file_dialog ();
  destroy_control_panel ();
  destroy_edit_panel ();
  destroy_route_panel ();
  destroy_map_panel ();
  if (app_info->conf_panel != NULL)
    {
      gtk_widget_destroy (app_info->conf_panel->window);
      g_free (app_info->conf_panel);
    }
  if (app_info->hlist_pane != NULL)
    {
      gtk_widget_destroy (app_info->hlist_pane->window);
      g_free (app_info->hlist_pane);
    }
  destroy_add_host_panel ();
  if (app_info->sinf_panel != NULL)
    {
      gtk_widget_destroy (app_info->sinf_panel->window);
      g_free (app_info->sinf_panel);
    }
  destroy_network_panel ();
  destroy_add_net_panel ();
  destroy_monitor_panel ();
  destroy_set_panel ();
  destroy_get_panel ();
  destroy_event_panel ();
  destroy_interface_panel ();
  destroy_browser_panel ();
  g_print ("destroy popup menus\n");
  /* if (app_info->host_popup_right)
     gtk_widget_unref (app_info->host_popup_right); -- Broke */
  g_print ("Kill Pixmap cache\n");
  destroy_pixmap_cache ();
  gtk_main_quit();
}

static gint
panel_delete_cb (GtkWidget *widget,
		 GdkEvent  *e,
		 gpointer  data)
{
  quit_button_cb (widget, data);
  return TRUE;
}


void
update_app_stat (gchar *msg, ...)
{
  va_list  ap;
  gchar    buf[1024];

  va_start (ap, msg);
  vsnprintf (buf, sizeof(buf), msg, ap);
  va_end (ap);

  map_update_stat (msg);   /* Temporary */
}

gint
draw_host (GtkWidget *widget, hosts *hentry)
{
  hosts     *new;
  
  if (find_host_by_name ((char*)hentry->hl_snmp.name) == NULL)
    {
      new = hl_add_host (hentry);
      if (new != NULL)
	{
	  
	  /*	  new->widget = new_host_widget (new); */
          map_add_host (new, 20.0, 20.0);
	  /*	  if (!GTK_WIDGET_REALIZED (scrolled))
	    gtk_widget_realize (scrolled);
	  color = get_color (HOST_UP_COLOR);
	  gdk_color_alloc (gdk_window_get_colormap (scrolled->window),
			   &color);
	  memcpy (&style, gtk_widget_get_style (scrolled), 
		  sizeof (GtkStyle));
	  for (i = 0; i < 5; i++)
	    memcpy (&style.bg[i], &color, sizeof (GdkColor));
	  
	  gtk_container_add (GTK_CONTAINER (scrolled), new->widget);
	  gdk_window_set_cursor (new->widget->window, 
				 gdk_cursor_new (GDK_HAND1) );
	  gtk_signal_connect (GTK_OBJECT (new->widget), "button_press_event",
			      GTK_SIGNAL_FUNC (host_button_cb),
			      NULL); */
	  new->snmp_running = FALSE;
	  /*
	  gtk_object_set_data (GTK_OBJECT (new->widget),"host_entry", new);
	  */
	  if (app_info->hlist_pane != NULL)
	    list_add (NULL, new, NULL);
	  if (app_info->brows_panel != NULL)
	    browser_add_host (new->hl_snmp.name);
	  /*
	  gtk_widget_show (new->widget);
	  gtk_widget_set_style (new->widget, &style);
	  app_info->current_host = new->widget;
	  */
	  app_info->host_count++;
	  update_known_hosts (app_info->host_count);
	}
     
    }
  return TRUE;
}

void
app_init()
{
  app_info = (gxsnmp *)g_malloc (sizeof (gxsnmp));
  app_info->x = 1;
  app_info->y = 1;
  app_info->current_host = NULL;
  app_info->conf_panel  = NULL;
  app_info->hlist_pane = NULL;
  app_info->sinf_panel  = NULL;
  app_info->netwk_panel = NULL;
  app_info->inter_panel = NULL;
  app_info->brows_panel = NULL;
  app_info->host_hash   = NULL;
  app_info->host_count  = 0;
  app_info->network_count = 0;
  app_info->root_width  = gdk_screen_width ();
  app_info->root_height = gdk_screen_height ();
}

/*
 * Program entry point
 */
int 
main (int argc, char *argv[])
{
  int           time_id;
  app_event     event;
  struct passwd *entry;

  argp_program_version = VERSION;
#ifdef HAS_GDK_IMLIB
  gdk_imlib_init ();
#endif

  bindtextdomain (PACKAGE, GNOMELOCALEDIR);
  textdomain (PACKAGE);                 
  gnome_init ("gxsnmp", NULL, argc, argv, 0, NULL);
#ifdef USE_GLE
  gle_init (&argc, &argv);
#endif

  entry = getpwuid (getuid());
  app_init ();
#ifndef GTK_HAVE_FEATURES_1_1_0
  gtk_accelerator_table_set_mod_mask (NULL, GDK_SHIFT_MASK |
				      GDK_CONTROL_MASK |
				      GDK_MOD1_MASK);
#endif
  event.category     = GX_EVENT_INFO;
  event.sub_category = GX_INFO_NONE;
  event.timestamp    = time (NULL);
  event.description  = g_strdup ("gxsnmp started.");
  add_event (&event);
  gtk_rc_parse ("./gxsnmpgtkrc");
#ifdef MAIN_DEBUG  
  g_print ("Pid: [%d]\n",getpid());
#endif
  init_mib();
  snmpinit ();
  
  if (getuid() != 0)
    {
      /*
       * Maybe do a dialog here or set a flag telling the user that 
       * ping and traceroute will be disabled because they are not running as
       * root?
       */
    }
  else
    {
      initpingsocket();
      initping();
    }
  if (load_config () == FALSE)
    {
      app_info->current_config.def_snmp_com  = DEFAULT_COMMUNITY;
      app_info->current_config.def_snmp_wcom = DEFAULT_WCOMMUNITY;
      app_info->current_config.def_snmp_retr = 5;
      app_info->current_config.def_snmp_port = 161;
      app_info->current_config.def_snmp_time = 30;
      app_info->current_config.def_sql_host  = g_strdup ("localhost");
      app_info->current_config.def_sql_user  = g_strdup (entry->pw_name);
      app_info->current_config.def_sql_db    = DEFAULT_DATABASE;
      app_info->snmp_running = 0;
    }
  plugins_init ();
  open_map_panel ();
  open_control_panel ();
  sql_load_network_table ();
  sql_load_host_table ();

  create_host_popup ( (GtkWindow *)app_info->window);
  
  time_id = gtk_timeout_add (1000, run_queue, NULL);
 
  gtk_main();
  return 0;
}

/* EOF */

