#! /bin/bash

# rclink2file - Convert old style /etc/rc?.d link structure
# Copyright (C) 1998  Martin Schulze <joey@debian.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111, USA.

# The functions element() and unique() are based on functions
# written by Winfried Trmper <winni@xpilot.org>

function element() {
    local element i

    element="$1"; shift
	
    [ "$1" = "in" ] && shift
    [ "$1" = "-" ] && return 1
    [ "$1" = "*" ] && return 0

    for i in $*
    do
	if [ "$element" = "$i" ]
	then
	    return 0
	fi
    done
    return 1
}

function unique() {
    local level_set i
    level_set="$1 "; shift

    for i in $*
    do
	if ! element $i in $level_set
	then
	    level_set="$level_set$i "
	fi
    done
    echo $level_set
}

cat <<EOF
# This file was automatically generated by $0. You can use your
# favourite editor or "./update-rc.d" to modify it.
#
# Format:
# <sort> <off-> <on-levels>     <command>
EOF

(cat <<EOF
05	-	1		/etc/init.d/single
EOF
for script in /etc/init.d/*
do
    filename=${script#/etc/init.d/}
# halt | reboot
    case $filename in
	boot | single | modules | *dist | *orig | skeleton | \
	rc | rcS | README | functions | powerfail | *.dpkg* | *.OLD)
	    continue
	    ;;
    esac
    seqs=""
    for link in /etc/rc[0-6S].d/[KS]??$filename
    do
	if [ -f $link ]
	then
	    nr=${link#/etc/rc?.d/[KS]}
	    nr=${nr%$filename}
	    seqs="$seqs$nr "
	fi
    done
    seqs=`unique $seqs`
    for seq in $seqs
    do
	STOP=""; START=""
	for link in /etc/rc[0-6S].d/K$seq$filename
	do
	    if [ -f $link ]
	    then
		nr=${link#/etc/rc}
		nr=${nr%.d/K$seq$filename}
		STOP=$STOP$nr,
	    fi
	done
	STOP=${STOP%%,}
	[ -z "$STOP" ] && STOP="-"

	for link in /etc/rc[0-6S].d/S$seq$filename
	do
	    if [ -f $link ]
	    then
		nr=${link#/etc/rc}
		nr=${nr%.d/S$seq$filename}
		START=$START$nr,
	    fi
	done
	START=${START%%,}
	[ -z "$START" ] && START="-"

	if [ "$START" != "-" -o "$STOP" != "-" ]
	then
	    echo -e "$seq\t$STOP\t$START\t\t/etc/init.d/$filename"
	fi

    done
done) | sort -n
echo "# THE LAST LINE IS NEVER READ!"
