#include <stdio.h>
#include <assert.h>
#include <sys/sysmacros.h>
#include "dinstall.h"
#include "../busybox/internal.h"
#include INCLINGUA


int true (void) {
    return 0;
}

#ifdef _TESTING_

int next_action(void);
int alternate_action(void);
int alternate1_action(void);
int previous_action(void);
int previous1_action(void);
int partition_disk(void);
int init_swap(void);
int activate_swap(void);
int no_swap(void);
int init_linux(void);
int mount_any(void);
int unmount_any(void);
int extract_kernel_and_modules(void); 
int extract_base(void);
int configure_drivers(void);
int configure_base(void);
int configure_network(void);
int make_bootable(void);
int make_boot_floppy(void);
int reboot_system(void);
int view_partitions(void);
int interactive_shell(void);
int configure_pcmcia(void);
int do_eject(void);

#else // !_TESTING_

static char * find_root (void) {
    char * root_device;
    char * target_device;
    struct fdisk_partition * p;

    if ( (root_device=block_device( "/",NULL )) == NULL ) {
	return NULL;
    }
    if ( (target_device=block_device("/target",NULL )) == NULL ) {
	/* Perhaps it's a loop-mounted fs, or NFS */
	if ((p = fdisk_find_partition_by_mntpoint("/target")) == NULL) {
	    free(root_device);
	    return NULL;
	}
	target_device = strdup(p->name);
    }
    if ( strcmp(root_device,target_device) ){
	free(root_device);
	return target_device;
    }
    free(root_device);
    free(target_device);
    root_device=strdup("");
    return root_device;
}

static int require_root(void) {
  if (!Root) {
    problemBox(MSG_REQUIRE_ROOT,MSG_REQUIRE_ROOT_T);
    return 1;
  }
  return 0;
}

#ifdef DO_EJECT
void eject_floppy(const char *device)
{
  sprintf( prtbuf,"eject %s",device );
  system( prtbuf );
}
#endif

#endif //_TESTING_

int main_menu (void) {
#ifndef _TESTING_
    char *found_root=NULL;
#endif
    struct stat statbuf;
    int (*next_action)(void);
    int (*alternate_action)(void);
    int (*alternate1_action)(void);
    int (*previous_action)(void);
    int (*previous1_action)(void);
    char *bufT,*bufN,*bufA,*bufA1,*bufP,*bufP1;
#define OPT_Next		1001
#define OPT_Alternate		1002
#define OPT_Alternate1		1003
#define OPT_Previous		1004
#define OPT_Previous1		1005
#define OPT_CONFIGURE_KEY	1006
#define OPT_PARTITION_DISK	1007
#define OPT_INITIALIZE_SWAP	1008
#define OPT_ACTIVATE_SWAP	1009
#define OPT_DO_WITHOUT_SWAP	1010
#define OPT_INITIALIZE_LINUX	1011
#define OPT_MOUNT_LINUX		1012
#define OPT_UMOUNT_LINUX	1013
#define OPT_INSTALL_OS		1014
#define OPT_INSTALL_BASE	1015
#define OPT_CONFIGURE_MODULES	1016
#define OPT_CONFIGURE_BASE	1017
#define OPT_CONFIGURE_NET	1018
#define OPT_DISK_BOOT		1019
#define OPT_FLOPPY_BOOT		1020
#define OPT_REBOOT		1021
#define OPT_VIEW_PARTITIONS	1022
#define OPT_EXECUTE_SHELL	1023
#define OPT_CONFIGURE_PCMCIA	1024
#define OPT_EJECT_FLOPPY	1025
#define OPT_RESTART_DINSTALL	1026
#define NITEMS	27
    int data, ilist[NITEMS],items, i, rs;
    struct d_choices choices[NITEMS];
    struct { char *string; int key; } entries[]={
	{MSG_CONFIGURE_KEY,OPT_CONFIGURE_KEY},
	{MSG_PARTITION_DISK,OPT_PARTITION_DISK},
	{MSG_INITIALIZE_SWAP,OPT_INITIALIZE_SWAP},
	{MSG_ACTIVATE_SWAP,OPT_ACTIVATE_SWAP},
	{MSG_DO_WITHOUT_SWAP,OPT_DO_WITHOUT_SWAP},
	{MSG_INITIALIZE_LINUX,OPT_INITIALIZE_LINUX},
	{MSG_MOUNT_LINUX,OPT_MOUNT_LINUX},
	{MSG_UMOUNT_LINUX,OPT_UMOUNT_LINUX},
	{MSG_INSTALL_OS,OPT_INSTALL_OS},
	{MSG_INSTALL_BASE,OPT_INSTALL_BASE},
	{MSG_CONFIGURE_MODULES,OPT_CONFIGURE_MODULES},
	{MSG_CONFIGURE_BASE,OPT_CONFIGURE_BASE},
	{MSG_CONFIGURE_NET,OPT_CONFIGURE_NET},
#if !#cpu(alpha)
	{MSG_DISK_BOOT,OPT_DISK_BOOT},
	{MSG_FLOPPY_BOOT,OPT_FLOPPY_BOOT},
#endif
	{MSG_REBOOT,OPT_REBOOT},
	{MSG_VIEW_PARTITIONS,OPT_VIEW_PARTITIONS},
	{MSG_EXECUTE_SHELL,OPT_EXECUTE_SHELL},
#if !#cpu(alpha)
	{MSG_CONFIGURE_PCMCIA,OPT_CONFIGURE_PCMCIA},
#endif
#ifdef DO_EJECT
	{MSG_EJECT_FLOPPY,OPT_EJECT_FLOPPY},
#endif
	{MSG_RESTART_DINSTALL,OPT_RESTART_DINSTALL},
	{NULL,0}
    };

#ifdef SERIAL_CONSOLE
    check_for_keyboard();
#endif

    for (;;) {
	pleaseWaitBox(MSG_WAIT_STATE);
        memset (choices,0,NITEMS*sizeof(struct d_choices));

#ifndef _TESTING_
	if (Root) {
	    found_root = strdup(Root->name);
	} 

	fdisk_reread();
	if (fdisk_disks == NULL) {
	    /* no swap on NFS for diskless workstation */
	    noSwap = 1;
	    /* no boot loader on local disk */
	    notInstalledLILO = 0;
	}

	if (found_root) {
	    Root = fdisk_find_partition_by_name(found_root);
	    free(found_root);
	    found_root=NULL;
	}

	if (! ( found_root = find_root() ) ){
	    if (Root) {
		sprintf(prtbuf,MSG_TROUBLE_ROOT_OK,Root->name); 
	    } else {
		sprintf(prtbuf,MSG_TROUBLE_ROOT_KO);
	    }
	    problemBox(prtbuf,MSG_PROBLEM);
	} else if ( ! Root ) {
	    Root = fdisk_find_partition_by_name(found_root);
	} else if (strcmp(Root->name, found_root)) {
	    sprintf(prtbuf,MSG_ROOT_CHANGED,Root->name,found_root);
	    problemBox(prtbuf,MSG_ROOT_CHANGED_T);
	    Root = fdisk_find_partition_by_name(found_root);
	}
	if (found_root) {
            free(found_root);
	    found_root=NULL;
        }
#endif //_TESTING_

	boxPopWindow();

	/* start building  menu entries */

	next_action = alternate_action = alternate1_action = &true;
	previous_action = previous1_action = &true;
	bufA = bufA1 = bufP = bufP1 = "";

	if ((! NAME_ISREG( "/tmp/kbdconf", &statbuf) )
		&& NAME_ISEXE( "/bin/loadkmap", &statbuf) )
	{
	    if (bootargs.kbd) {
		    configure_keyboard(bootargs.kbd);
		    continue;
	    } 
	    next_action=configure_keyboard_m;
	    bufT=MSG_KEY_NOT_CONFIGURED;
	    bufN=MSG_CONFIGURE_KEY;
	    /* Alternate step:
	     * configure the network instead of partitioning hard drives
	     * in case there is no hard drives connected to the host
	     * (diskless installation) */
	    if (fdisk_disks) {
		bufA=MSG_PARTITION_DISK;
		alternate_action=partition_disk;
	    }
	    else {
		bufA=MSG_CONFIGURE_NET;
		alternate_action=configure_network;
	    }
	} else if ( (swapon_partitions == NULL) && 
		    (fdisk_partitions_by_type[FSTYPE_SWAP] == NULL) &&
		    (noSwap == 0) ){
	/* No "Linux swap" partitions have been created. */
	    next_action=partition_disk;
	    alternate_action=no_swap;
	    bufT=MSG_NO_SWAP;
	    bufN=MSG_PARTITION_DISK;
	    bufA=MSG_DO_WITHOUT_SWAP;
	} else if( (! Root) && (fdisk_disks == NULL) &&
		   (! NAME_ISREG( "/tmp/notarget/etc/hostname",&statbuf)) &&
		   (! NAME_ISREG( "/target/etc/hostname",&statbuf))) {
	/* Diskless install: need to configure the network before
	 * mouting any target */
	    next_action=configure_network;
	    bufT=MSG_NET_UNCONF_DISKLESS; 
	    bufN=MSG_CONFIGURE_NET;
	} else if( (! Root) && (fdisk_disks != NULL) &&
	           (fdisk_partitions_by_type[FSTYPE_EXT2] == NULL) ) {
	/* No "Linux native" partitions have been created. */
	    next_action=partition_disk;
	    bufT=MSG_NO_LINUX;
	    bufN=MSG_PARTITION_DISK;
	} else if ( (swapon_partitions == NULL) && (noSwap == 0)) {
	/* The swap partition has not been initialized and activated. */
	    next_action=init_swap;
	    alternate_action=activate_swap;
	    alternate1_action=no_swap;
	    previous_action=partition_disk;
	    bufT=MSG_LINUX_AND_SWAP;
	    bufN=MSG_INITIALIZE_SWAP;
	    bufA=MSG_ACTIVATE_SWAP;
	    bufA1=MSG_DO_WITHOUT_SWAP;
	    bufP=MSG_PARTITION_DISK;
	} else if (! Root && fdisk_disks != NULL) {
	/* The root partition has not been mounted. */
	    next_action=init_linux;
	    alternate_action=mount_any;
	    bufT=MSG_NONE_MOUNTED;
	    bufN=MSG_INITIALIZE_LINUX;
	    bufA=MSG_MOUNT_LINUX;
	} else if (! Root && fdisk_disks == NULL) {
	/* The root partition has not been mounted (diskless install). */
	    next_action=mount_any;
	    bufT=MSG_NONE_MOUNTED_DISKLESS;
	    bufN=MSG_MOUNT_LINUX;
	} else if ( (! NAME_ISREG("/target/vmlinuz",&statbuf) ) || 
                    (! NAME_ISREG(
		    "/target/usr/lib/module_help/descr.gz",&statbuf) ) ) {
            /* The operating system kernel and the modules */
            /* have not been installed. */
            next_action=extract_kernel_and_modules;
            bufT=MSG_ROOT_MOUNTED;
            bufN=MSG_INSTALL_OS;
	    if (fdisk_disks != NULL) {
		alternate_action=init_linux;
		alternate1_action=mount_any;
		bufA=MSG_INITIALIZE_LINUX;
		bufA1=MSG_MOUNT_LINUX;
	    }
	    else {
		alternate_action=mount_any;
		bufA=MSG_MOUNT_LINUX;
	    }
	} else if (! NAME_ISREG("/target/etc/conf.modules",&statbuf) ) {
	/* The modules have not been configured. */
	    next_action=configure_drivers;
	    bufN=MSG_CONFIGURE_MODULES;
#if !#cpu(alpha)
	  if(! NAME_ISREG("/target/etc/pcmcia.conf", &statbuf) ) {
	    bufT=MSG_OS_INSTALLED_PCMCIA; 
	    alternate_action=configure_pcmcia;
	    bufA=MSG_CONFIGURE_PCMCIA;
	  } else
#endif
            {
              bufT=MSG_OS_INSTALLED;
            }
	} else if( (! NAME_ISREG( "/tmp/notarget/etc/hostname",&statbuf) ) &&
		   (! NAME_ISREG( "/target/etc/hostname",&statbuf) )) {
	/* The network has not been configured. */
	    next_action=configure_network;
	    bufT=MSG_NET_UNCONFIGURED; 
	    bufN=MSG_CONFIGURE_NET;
	} else if (! NAME_ISREG( "/target/sbin/init",&statbuf) ) {
	/* The base system has not been installed. */
	    next_action=extract_base;
	    bufT=MSG_MODULES_CONFIGURED;
	    bufN=MSG_INSTALL_BASE;
	} else if ( NAME_ISREG( "/target/sbin/unconfigured.sh",&statbuf) ) {
	/* The base system has not been configured. */
	    next_action=configure_base;
	    bufT=MSG_BASE_INSTALLED;
	    bufN=MSG_CONFIGURE_BASE;
#if !#cpu(alpha)
	} else if ( notCreatedBootFloppy && notInstalledLILO ) {
	    next_action=make_bootable;
	    alternate_action=make_boot_floppy;
	    alternate1_action=reboot_system;
	    bufT=MSG_NO_BOOT;
	    bufN=MSG_DISK_BOOT;
	    bufA=MSG_FLOPPY_BOOT;
	    bufA1=MSG_REBOOT;
	} else if ( notCreatedBootFloppy ) {
	/* The boot floppy has not been created. */
	    next_action=make_boot_floppy;
	    alternate_action=reboot_system;
	    bufT=MSG_NO_BOOT_FLOPPY;
	    bufN=MSG_FLOPPY_BOOT;
	    bufA=MSG_REBOOT;
#endif
	} else {
	/* Nothing left to do but reboot the system. */
	    next_action=reboot_system;
	    bufT=MSG_MOMENT_OF_TRUTH;
	    bufN=MSG_REBOOT;
	}

	items=0;
	choices[items].tag=MSG_NEXT;
	choices[items].string=bufN;
	ilist[items]=OPT_Next;
	items++;
	if (bufA[0]) {
	    choices[items].tag=MSG_ALTERNATE;
	    choices[items].string=bufA;
	    ilist[items]=OPT_Alternate;
	    items++;
	}
	if (bufA1[0]) {
	    choices[items].tag=MSG_ALTERNATE1;
	    choices[items].string=bufA1;
	    ilist[items]=OPT_Alternate1;
	    items++;
	}
	if (bufP[0]) {
	    choices[items].tag=MSG_PREVIOUS;
	    choices[items].string=bufP;
	    ilist[items]=OPT_Previous;
	    items++;
	}
	if (bufP1[0]) {
	    choices[items].tag=MSG_PREVIOUS1;
	    choices[items].string=bufP1;
	    ilist[items]=OPT_Previous1;
	    items++;
	}
	items++;
	for (i=0;entries[i].string;i++) {
	    choices[items].string=entries[i].string;
	    ilist[items]=entries[i].key;
	    items++;
	}

	rs = menuBox(bufT, MSG_TITLE_MENU, choices, items, 0);
	data = ilist[rs];

#ifndef _TESTING_
	switch (data) {
	    case OPT_Next: next_action(); break;
	    case OPT_Alternate: alternate_action(); break;
	    case OPT_Alternate1: alternate1_action(); break;
	    case OPT_Previous: previous_action(); break;
	    case OPT_Previous1: previous1_action(); break;
	    case OPT_CONFIGURE_KEY: configure_keyboard_m(); break;
	    case OPT_PARTITION_DISK: partition_disk(); break;
	    case OPT_INITIALIZE_SWAP: init_swap(); break;
	    case OPT_ACTIVATE_SWAP: activate_swap(); break;
	    case OPT_DO_WITHOUT_SWAP: no_swap(); break;
	    case OPT_INITIALIZE_LINUX: init_linux(); break;
	    case OPT_MOUNT_LINUX: mount_any(); break;
	    case OPT_UMOUNT_LINUX: unmount_any(); break;
	    case OPT_INSTALL_OS:
	      if (Root) { 
		extract_kernel_and_modules(); 
	      } else { require_root(); } break;
	    case OPT_INSTALL_BASE:
	      if (Root) { 
		extract_base();
	      } else { require_root(); } break;
	    case OPT_CONFIGURE_MODULES:
	      if (Root) { 
		configure_drivers();
	      } else { require_root(); } break;
	    case OPT_CONFIGURE_BASE:
	      if (Root) { 
		configure_base(); 
	      } else { require_root(); } break;
	    case OPT_CONFIGURE_NET:
/*	      if (Root) { */
		configure_network();
/*	      } else { require_root(); } */ break;
	    case OPT_DISK_BOOT:
	      if (Root) { 
		make_bootable();
	      } else { require_root(); } break;
	    case OPT_FLOPPY_BOOT:
	      if (Root) { 
		make_boot_floppy();
	      } else { require_root(); } break;
	    case OPT_REBOOT: reboot_system(); break;
	    case OPT_VIEW_PARTITIONS: view_partitions(); break;
	    case OPT_EXECUTE_SHELL: interactive_shell(); break;
	    case OPT_CONFIGURE_PCMCIA:
	      if (Root) {
		configure_pcmcia();
	    } else { require_root(); } break;
#ifdef DO_EJECT
	    case OPT_EJECT_FLOPPY: do_eject(); break;
#endif
	    case OPT_RESTART_DINSTALL: exit(-1);
	    default: assert(0);
	}
#else  // _TESTING_
        sprintf(prtbuf,"You've chosen item: %d",data);
        problemBox(prtbuf,"Option chosen");
	if (data == OPT_REBOOT) return(0);
#endif // _TESTING_
    }
    return 0;
}

#ifdef _TESTING_
int configure_keyboard(char *kbd) {
	sprintf(prtbuf,"Automatically configuring keymap %s .",kbd);
	problemBox(prtbuf,"Test message");
	system("touch /tmp/kbdconf");
	return true();
}
/*
 * To test, compile using: make main_menu_test
 */
void main(void) {
  bootargs.kbd="qwerty/es";

  initScreen("Main Menu test program");

  main_menu();

  finishScreen();

  if(bootargs.kbd) system("rm /tmp/kbdconf");
}
#endif

/* vi: set sw=8 ts=8: */
