#ifndef _DINSTALL_H_
#define _DINSTALL_H_

#define KERDISKIMG	"resc1440%s%s.bin"
#define DRVDISKIMG	"drv1440%s%s.bin"
#define BASETGZ		"base2_1.tgz"

#define  CLEAR "[H[J"

#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <sys/stat.h>
#include "../libfdisk/fdisk.h"
#include "boxes.h"

#define NAME_ISDIR(name,statbuf) \
	( (! stat(name,statbuf) ) && S_ISDIR((statbuf)->st_mode) )
#define NAME_ISREG(name,statbuf) \
	( (! stat(name,statbuf) ) && S_ISREG((statbuf)->st_mode) )
#define NAME_ISEXE(name,statbuf) \
	( (! stat(name,statbuf) ) && S_ISREG((statbuf)->st_mode) && \
	  ( S_IXUSR & (statbuf)->st_mode ) )
 
int no_match(const char *path, const char *name, __mode_t mode);

struct BootArgs {
  char *root;
  char *kbd;
  int istecra;
} bootargs;

enum extract_type { kernel, base } disqtype;

#define PRTBUFSIZE 2048
char prtbuf[PRTBUFSIZE];
char *InstallationRootDevice,*Archive_Dir; 
struct fdisk_partition *Root;
int noSwap, notCreatedBootFloppy, notInstalledLILO;
#if #cpu (m68k) || #cpu (powerpc)
  const char *Arch2;
#endif

struct fdisk_partition *
    select_not_mounted(const char *message, const char *title, int ntypes, ...);

int addtolist(char **list, const char *element);
int mount_and_check_floppy (char *device, const char *type, const char *text);
int choose_medium(void);
int getFloppies(const char * device, const char * filename);
int is_nfs_partition(const char* target);
int is_network_configured(void);
const char* target_path(const char* s);
int check_target_path(void);
int check_dir(const char* dirname);
int check_pending_config(void);

void initMonoScreen(void);
int color_or_monochrome(void);
int release_notes(void);
int is_root_a_floppy (void);
int main_menu (void);
int partition_disk (void);
int init_swap (void);
int init_linux (void);
int no_swap (void);
int mount_any (void);
int unmount_any (void);
int activate_swap (void);
int configure_keyboard_m (void);
int configure_keyboard (char* kbd);
int extract_kernel_and_modules (void);
int extract_base (void);
int view_partitions (void);
int interactive_shell (void);
int reboot_system (void);
int configure_drivers (void);
int configure_base (void);
int make_bootable (void);
int make_boot_floppy (void);
int configure_network (void);
int configure_pcmcia (void);

extern char *real_kver;
extern char suffix_arch[];
extern char *kernel_image_filename;
extern char *drivers_image_filename;

#if #cpu (m68k)
# define SERIAL_CONSOLE
# define SCSI_FLOPPY
# define NFSROOT
void find_scsi_floppy (void);
#elif #cpu (sparc)
# define SERIAL_CONSOLE		/* serial console recognized */
# define DO_EJECT		/* auto eject floppy drives */
# define NFSROOT		/* network boot */
# define MULTI_KERNELS		/* multi-kernels releases installations */
#elif #cpu (i386)
# define MULTI_KERNELS		/* multi-kernels enabled for tecra support */
#elif #cpu (powerpc)
# define SERIAL_CONSOLE
# define NFSROOT
#endif

#ifdef DO_EJECT
void eject_floppy(const char *device);
int do_eject (void);
#else
# define eject_floppy(device)	/* nada */
#endif

#ifdef SERIAL_CONSOLE
void check_for_keyboard(void);
#endif

#endif
