#!	/bin/sh
# Root Disk maker. Bruce Perens, December 1995
# Dale Scheetz, Sven Rudolph 1996, 1997
# Enrique Zanardi 1998
# Hartmut Koptein, 1998; powerpc support
# Matej Vela, 1998 [non-ISO-8859-1 charset support]
# This is free software under the GNU General Public License.

# Dumb GNU tar is broken at the moment.
set -e
#set -v
set -x

. common.sh

export LANG=C

first () {
	echo $1
}

last () {
	eval 'echo $'$#
}

# Abort on any non-zero return.
umask 022

if [ $# -lt 6 ]; then
echo "Usage: "$0" revision-extension archive blocks debian-version system language font sfont" 1>&2
	cat 1>&2 << EOF

	revision-extension: the revision extension of the kernel.
	archive: the directory containing the Debian binary packages.
	blocks: the size of the floppy in 1K blocks, use 720, 1200, or 1440.
	debian-version: version of the Debian release.
	system: name of the target system.
	language: language for the release notes
	font: name of the preloaded font, if any
	sfont: name of the font loaded by syslinux, if any
EOF

	exit -1
fi

revext=$1

# Set this to the location of the package archive.
archive=$2

# Set to the number of blocks per floppy.
blocks=$3

#Set this to the Debian version
debianversion=$4

# Set this to the system
system=$5

# Set this to the language for the release notes.
language=$6

# Set this to the font loaded before dinstall, if any.
font=$7

# Set this to the font loaded by syslinux, if any.
sfont=$8

# This is the directory containing fonts.
fontsdir=usr/share/consolefonts

# Set this to the block device for the floppy disk.
floppy=/var/tmp/floppy-image.$$

mnt=/var/tmp/mnt.rootdisk

if [ ! -d $archive/. ]; then
	echo "Error: "$archive": not a directory." 1>&2
	exit -1
fi

. common.sh

# To build a rootdisk for an other architecture we need the name
export arch="`dpkg --print-architecture`"

case "$arch" in
    alpha)
	export ldlib=ld-linux.so.2
	libcso=libc.so.6.1
	libcver=2.0.7
	;;
    m68k)
	export ldlib=ld.so.1
	libcso=libc.so.6
	libcver=2.0.7
    ;;
    powerpc)
	export ldlib=ld.so.1
	libcso=libc.so.6
	libcver=2.1
    ;;
    sparc)
	export ldlib=ld-linux.so.2
	libcso=libc.so.6
	libcver=2.0.105
    ;;
    i386)
	export ldlib=ld-linux.so.2
	libcso=libc.so.6
	libcver=2.0.7
    ;;
esac
echo ld.so: $ldlib

# [ED] Hmm, either KVER should be passed to make or this call completely
#      removed.  BTW, make is called from the top Makefile (all_subdirs target)
#(cd utilities; make)

# Try to unmount anything that should not be mounted.
($ROOTCMD umount $mnt; $ROOTCMD umount $floppy; true)2>/dev/null >/dev/null

case "$arch" in
    sparc|powerpc|alpha)
	fstype=ext2
    ;;
    *)
	fstype=minix
    ;;
esac

mkdir -p $mnt

# Zero the entire disk, so that when I compress the raw disk image,
# unused blocks will compress well.
dd if=/dev/zero of=$floppy bs=1k count=${blocks}

# Make a Minix/ext2 filesystem.
case $fstype in
minix)
	/sbin/mkfs.minix -n30 -i 850 $floppy ${blocks}
	;;
ext2)
	mke2fs -F -i 4096 -m 0 $floppy ${blocks}
	;;
esac

# Mount the disk.
$ROOTCMD mount -t $fstype -o loop $floppy $mnt

# get more space on ext2 fs
[ $fstype = ext2 ] && rmdir $mnt/lost+found

# Temporary directories
E=/var/tmp/extract-tmp-$$
R=/var/tmp/root-tmp-$$

# The home of the scripts used by this script.
scripts=`pwd`/scripts/rootdisk

exit=false

for i in \
	$scripts/EXTRACT_LIST_all \
	$scripts/EXTRACT_LIST_${arch} \
	$scripts/SMALL_BASE_LIST_all \
	$scripts/SMALL_BASE_LIST_${arch} \
	$scripts/LINKS \
	;do
	if [ ! -f $i ]; then
		echo "Can't open $i"
		exit=true
	fi
done
if $exit; then
	exit -1
fi

# A list of all the hard links to make to the "busybox" program.
LINKS="`grep -v '^#' $scripts/LINKS`"

# Expand the package names into full pathnames.
PACKAGE_PATHS=`make_paths \`cat $scripts/EXTRACT_LIST_all $scripts/EXTRACT_LIST_${arch}\``

if $exit; then
	exit -1
fi

if [ -d $E ]; then
	mv -f $E $E.old
	rm -f -r $E.old &
fi

mkdir -p -m 755 $E

for i in $PACKAGE_PATHS; do
	echo Extracting $i 1>&2
	dpkg-deb --extract $i $E
done

$scripts/strip_executables $E/bin/* $E/usr/bin/* $E/sbin/* $E/usr/sbin/* \
 $E/lib/* $E/usr/lib/*

mkdir -p $R/dev/inet
case "$arch" in
	alpha)
		boot_floppies_dev="generic std loop hdc hdd hde hdf hdg hdh sdc sdd sde sdf sdg sdh initrd rtc"
		;;
	i386)
# generic-i386 is a disk space hog. We really don't need a bazillion /dev/pty*
# devices on the root floppy, do we?
		boot_floppies_dev="std tty1 tty2 tty3 tty4 ttyS0 ttyS1 ttyS2 ttyS3 lp fd fd0 fd1 xda xdb eda edb hda hdb hdc hdd hde hdf hdg hdh sda sdb sdc sdd sde sdf sdg sdh initrd rtc loop scd0 scd1 scd2 scd3 sonycd mcd mcdx cdu535 lmscd sbpcd aztcd bpcd"
		;;
	m68k)
		boot_floppies_dev="std tty1 tty2 tty3 tty4 ttyS0 ttyS1 fd fd0 fd1 hda hdb hdc hdd sda sdb sdc sdd sde sdf sdh ada adb adc add ade adf fb initrd rtc loop scd0 scd1 scd2 scd3"
		;;
	powerpc)
		boot_floppies_dev="std tty1 tty2 tty3 tty4 ttyS0 ttyS1 ttyS2 ttyS3 lp fd fd0-bare fd1-bare hda hdb hdc hdd sda sdb sdc sdd sde sdf sdg sdh scd0 scd1 scd2 scd3 st0 st1 initrd rtc loop adb fb"
		;;
	sparc)
		boot_floppies_dev="std tty1 tty2 tty3 tty4 ttyS0 ttyS1 ttyS2 ttyS3 lp fd fd0-bare fd1-bare hda hdb hdc hdd sda sdb sdc sdd sde sdf sdg sdh scd0 scd1 st0 st1 initrd rtc loop"
		# for serial console on 2.0 kernel
		# (not created by makedev anymore)
		mknod $R/dev/cua0 c 5 64
		mknod $R/dev/cua1 c 5 65
		;;
	*)
		boot_floppies_dev="generic hdc hdd hde hdf hdg hdh sdc sdd sde sdf sdg sdh initrd rtc"
		;;
esac
for i in $boot_floppies_dev; do
	(cd $R/dev; /dev/MAKEDEV $i)
done

# Warning: New kernels need a "console" device, not a symlink.
if [ ! -c $R/dev/tty0 ]; then
	mknod $R/dev/tty0 c 4 0
fi
#ln -s tty0 $R/dev/console
mknod $R/dev/console c 5 1

if [ ! -b $R/dev/ram0 ]; then
	mknod $R/dev/ram0 b 1 0
fi

T=./tmp-$$
mkdir $T
(cd $scripts/prototype; tar clf - . --exclude CVS --exclude .tar-place-holder)\
  | (cd $T;tar xvlpf -)
# fix etc/rc
if [ -n "$font" ]; then
	str="[ -f /$fontsdir/$font ] \&\& loadfont < /$fontsdir/$font"
fi
sed -e "s/__FSTYPE__/$fstype/" -e "s+__LOADFONT__+$str+g" \
    < $scripts/prototype/etc/rc > $T/etc/rc

# create symlinks in tempdir (cvs doesn't preserve symlinks)
ln -sf ps $T/bin/uname
ln -sf ../bin/ps $T/sbin/lsmod
ln -sf ../bin/ps $T/sbin/lilo
ln -sf ../../bin/ps $T/usr/bin/emacs
ln -sf ../bin/ps $T/bin/grep
ln -sf ../bin/ps $T/bin/fgrep
# superformat calls mformat automatically
ln -sf ../../bin/ps $T/usr/bin/mformat
ln -sf ../../bin/ps $T/usr/bin/vi
ln -sf ../tmp $T/var/

(cd $T; tar clf - . ) | (cd $R;tar xvlpf -)
rm -rf $T

# Use tar to do the copying because it preserves hard links.
(cd $E; tar --files-from=$scripts/SMALL_BASE_LIST_all -cf -)|(cd $R;tar xvlpf -)
(cd $E; tar --files-from=$scripts/SMALL_BASE_LIST_$arch -cf -)|(cd $R;tar xvlpf -)

# Add the font if neccessary.
if [ -n "$font" ]; then
	for fonttest in $E/$fontsdir/$font $scripts/consolefonts/$font; do
		[ -f "$fonttest" -o -f "$fonttest.gz" ] && fontfound=$fonttest
	done
	if [ "$fontfound" ]; then
		mkdir -p $R/$fontsdir
		gzip -cdf $fontfound > $R/$fontsdir/$font
	fi
fi

if [ -n "$sfont" ]; then
	for fonttest in $E/$fontsdir/$sfont $scripts/consolefonts/$sfont; do
		[ -f "$fonttest" -o -f "$fonttest.gz" ] && sfontfound=$fonttest
	done
	if [ "$sfontfound" ]; then
		if [ `gzip -cdf $sfontfound | wc -c` = 4096 ]; then
			printf '\x36\x04\x00\x10' > $sfont
			gzip -cdf $sfontfound >> $sfont
		else
			gzip -cdf $sfontfound | psfstriptable $sfontfound $sfont
		fi
	fi
fi

# Create passwd and group from base-passwd master files
cp $E/usr/share/base-passwd/passwd.master $R/etc/passwd
cp $E/usr/share/base-passwd/group.master $R/etc/group

# Create conf.modules (Code "stolen" from update-modules)
CFGFILE=$R/etc/conf.modules
HEADER="### This file is automatically generated by update-modules"
CONF=$E/etc/modutils/arch/$arch
if [ "$arch" = m68k ]; then
    CONF=${CONF}.$system
    if [ ! -f $CONF ]; then
         CONF=$E/etc/modutils/arch/m68k.generic
    fi
fi
if [ ! -f $CONF ]; then
    CONF=$E/etc/modutils/arch/generic
fi
echo $HEADER > $CFGFILE
cat <<EOF >> $CFGFILE
#
# Please do not edit this file directly. If you want to change or add
# anything please take a look at the files in /etc/modutils and read
# the manpage for update-modules.
#
EOF
for cfg in $E/etc/modutils/* $CONF ; do
    if [ -f $cfg ]; then 
        cat $cfg >> $CFGFILE
    fi
done

# ED: add a prototype for bootable floppy image on sparc architecture (SILO)
if [ "$arch" = sparc ]; then
	mkdir $R/usr/lib/dbootstrap
	cp silo1440k*.gz $R/usr/lib/dbootstrap
	# superformat doesn't work at all.  Remove it actually (one has to
	# provide a formatted medium to create the rescue disk).
	# (see scripts/rootdisk/SMALL_REMOVE_LIST_sparc)
fi

if [ "$system" = bvme -o "$system" = mvme ]; then
	# superformat doesn't work with SCSI floppies.  Remove it (and ask for
	# formatted medium to create the rescue disk).
	rm -f $R/usr/bin/superformat
fi

if [ "$revext" = lowmem ]; then
	( cd $R; rm -f sbin/badblocks sbin/cfdisk sbin/e2fsck;
		rm -f sbin/fsck sbin/fsck.ext2 sbin/pnpdump sbin/route;
		rm -f sbin/ifconfig sbin/isapnp sbin/losetup;
		rm -rf etc/terminfo/a;
		rm -f bin/cpio bin/mount bin/umount;
		rm -f usr/bin/superformat;
	)
fi

# Copy the required libraries
LIBRARIES=""
EXECUTABLES="$R/bin/* $R/sbin/* $R/usr/bin/*"

#   ldconfig.new is statically linked
EXECUTABLES=`echo $EXECUTABLES | sed s%$R/sbin/ldconfig.new%%g`

#   Look for the required libraries under $E
TMP=`LD_LIBRARY_PATH=$E/lib:$E/usr/lib ldd $EXECUTABLES 2>/dev/null | \
	awk -v E="^$E" -v L="/lib/$ldlib" -- '$3=="not" {print $1; next}; \
		($3!~E) && ($1!~L) {print $3}' | grep -v "dynamic" | \
	sort -u`

#        awk -v E="^$E" -v L="$ldlib" -- '$3=="not" {print $1; next}; \
#		($3!~E) && ($1!~"/lib/"L) {print $3}' | \
#	sort -u`

#   ld-linux.so.2 is always linked with its full path, so ldd won't look
#   for it under $E. We have to do it 'by hand'
if [ ! -f $E/lib/$ldlib ]; then
	TMP="$TMP /lib/$ldlib"
fi

if [ ! -z "$TMP" ]; then
        echo "The following required libraries weren't extracted:"
        echo $TMP
        exit -1
fi

#   We have all the required libraries. Copy them under $R
TMP=`LD_LIBRARY_PATH=$E/lib:$E/usr/lib ldd $EXECUTABLES 2>/dev/null | \
        awk -- '{print $3}' | fgrep -v "dynamic" | sort -u`
for i in $TMP; do 
	j=`echo $i |sed -e "s%^$E%.%g" -e "s%^/%./%" `
	LIBRARIES="$LIBRARIES $j" 
        if [ -L $i ]; then
                j=`ls -l $i |awk -v J=\`dirname $i\` -- '{print J"/"$NF}' | \
                        sed -e "s%^$E%.%g" -e "s%^/%./%" `
                LIBRARIES="$LIBRARIES $j"
        fi
done
# Add the resolver and DNS libraries
LIBRARIES="$LIBRARIES ./lib/libresolv-$libcver.so ./lib/libnss_dns-$libcver.so"
(cd $E; tar -cf - $LIBRARIES)|(cd $R ; tar xvlpf -)

rm -f -r $E &

cp utilities/busybox/busybox $R/sbin/init
# No keymaps for BVME and MVME
if [ "$system" != bvme -a "$system" != mvme ]; then
       cp keymaps.tgz $R/etc/
fi

$scripts/strip_executables $R/sbin/init

(cd $R; for j in $LINKS; do \
	if [ ! -f $j ]; then \
		ln sbin/init $j ; \
	fi; \
done; )

if [ "$revext" != lowmem ]; then
	(cd $R/sbin; ln e2fsck fsck.ext2)
	(cd $R/sbin; ln e2fsck fsck)
fi

(cd $R/bin; ln ash sh)
(cd $R/bin; ln ae edit)
# ED: this link is already in the sparc libc6 package [bug?]
if [ ! -f $R/lib/$ldlib ]; then
	(cd $R/lib; ln `last ld-$libcver.so` $ldlib)
fi

if [ "$revext" = lowmem ]; then
	touch $R/etc/revision_ext.$revext
fi

if [ -z "$MAINTAINER" ]
then
	MAINTAINER=`dpkg-parsechangelog | \
		awk -- '/^Maintainer/ {$1="" ; print $0}'|sed 's/^ *//'`
fi

m4 $scripts/messages/$language/release_notes \
	-D__debianversion__=$debianversion \
	-D__date__="`date +%Y-%m-%d`" \
	-D__floppyversion__="`dpkg-parsechangelog | \
			awk -- '/^Version/ {print $2}'`" \
	-D__username__="${MAINTAINER}" \
	>$R/release_notes

# Kludge - remove when this is fixed.
if [ "$arch" = "m68k" ]; then
#We need a fdisk-wrapper...
  cp $scripts/fdisk-m68k $R/sbin/fdisk
fi

#We need a fdisk-wrapper (hfs / msdos)
if [ "$arch" = "powerpc" ]; then
  cp $scripts/fdisk-powerpc $R/sbin/fdisk
fi

# ED: sparc partially supports library reduction (bug in the linker)
# espy: it appears to be a generic glibc 2.1 problem
#     libslang is ok but not libc6 :-P
if ! [ "$arch" = sparc -o "$arch" = powerpc -o "$arch" = arm ]; then
  rm -f $R/lib/libc-$libcver.so $R/lib/$libcso
fi

SLVER=1.2.2
SLMAJ=1.2.2

rm -f $R/usr/lib/libslang.so.$SLVER $R/lib/libslang.so.$SLVER

EXECUTABLES="$R/bin/* $R/sbin/* $R/usr/bin/* $R/usr/sbin/* $R/lib/* $R/usr/lib/*"
#   ldconfig.new is statically linked
EXECUTABLES=`echo $EXECUTABLES | sed s%$R/sbin/ldconfig.new%%g`

$scripts/generate_library libslang.so.$SLVER "-t /usr/lib/libslang$SLMAJ*_pic.a \
	/lib/$libcso" $R/lib/libslang.so.$SLVER $EXECUTABLES

EXECUTABLES="$EXECUTABLES $R/lib/libslang.so.$SLVER"

if ! [ "$arch" = sparc -o "$arch" = powerpc -o "$arch" = arm ]; then
	$scripts/generate_library $libcso "/usr/lib/libc_pic/soinit.so \
	    /usr/lib/libc_pic.a /usr/lib/libc_pic/sofini.so \
	    /usr/lib/libc_pic/interp.so $R/lib/$ldlib -e __libc_main" \
	    $R/lib/$libcso $EXECUTABLES
#else
#	# It seems glibc 2.1 needs a version script to be able to create the
#	# small lib (thanks to Joel Klecker <jk@espy.org> pointing out the
#	# problem), but even with it, the generated library is not fully
#	# functional :-(
#	# (note: remove the cc -s option in $scripts/generate_library)
#	$scripts/generate_library $libcso \
#	    "-Wl,--version-script=/usr/lib/libc_pic/libc.map \
#	    -Wl,--whole-archive /usr/lib/libc_pic/soinit.so -Wl,--no-whole-archive /usr/lib/libc_pic.a \
#	    -Wl,--whole-archive /usr/lib/libc_pic/sofini.so /usr/lib/libc_pic/interp.so \
#	    $R/lib/$ldlib -Wl,--no-whole-archive -e __libc_main" $R/lib/$libcso $EXECUTABLES
fi

/usr/sbin/chroot $R /sbin/ldconfig.new -v
rm -f $R/sbin/ldconfig.new &

# Some files aren't needed until the modules are installed (ifport,
# cardmgr,... ). They will come in the drivers disk, freeing up some
# space in the root disk. But we have to take them into account while
# building the stripped libraries. So, let's include them in the
# rootdisk, generate the libraries, and then remove them before building
# the disk image.
files_to_remove=`cat $scripts/SMALL_REMOVE_LIST_all $scripts/SMALL_REMOVE_LIST_$arch`
if [ ! -z "$files_to_remove" ]; then
	(cd $R; rm $files_to_remove)
fi

# Replace symbolic links on the floppy with hard links! This saves one block
# per link.
(cd $R;find . -type l -printf '(cd `dirname %p`;if [ ! -d %l ]; then rm %f; if ln %l %f 2>/dev/null; then true; else ln -s %l %f ; fi; fi)\n') | (cd $R ;sh)

# How to store our boot messsage
case "$arch" in
    alpha)
	nlfmt="cat -"       #  UNIX newline convention
    ;;
    arm)
	echo "No support (yet) for ARM!"
	exit 1
    ;;
    i386)
        nlfmt="recode $charset:ibmpc"
    ;;
    m68k)
          case "$system" in
              amiga|atari)
                  nlfmt="recode $charset:ibmpc"       # MSDOS newline convention
              ;;
	      mac)
		  nlfmt="recode $charset:applemac"    # Mac newline convention
	      ;;
              mvme|bvme)
                  nlfmt='cat -'       # UNIX newline convention
              ;;
          esac
    ;;
    mips)
	echo "No support (yet) for Mips!"
	exit 1
    ;;
    powerpc)
            case "$system" in
              apus)
                  echo "Don't know what to do for APUS"
                  echo "Use for the moment the m68k-amiga boot-floppies"
                  exit 1
              ;;
              chrp|prep)
                  nlfmt="recode $charset:ibmpc"        # MSDOS newline convention
              ;;
              mbx)
                  echo "Don't know what to do for MBX"
                  exit 1
              ;;
              pmac)
                  nlfmt="recode $charset:applemac"     # Mac newline convention
              ;;
              esac
    ;;
    sparc)
	nlfmt='cat -'	# UNIX newline convention
    ;;
esac

cat $scripts/messages/$language/boot_message \
    | $nlfmt > $R/boot_message

echo "root">$R/type.txt

#copy to floppy image

(cd $R; tar cf - .) | (cd $mnt; tar xvpf -)

rm -f -r $R &

# put the loop module on rootdisk if not compiled in the kernel itself
# (get it from modules.tgz)
# ED HACK: the BF_LOOP variable can redirect the source of the loop.o file
if [ -n "$BF_LOOP" ]; then
	cp -p $BF_LOOP $mnt/loop.o
elif tar tvzf modules.tgz|grep /loop.o >/dev/null; then
	tar xOzf modules.tgz lib/modules/\*/block/loop.o > $mnt/loop.o
	test -s $mnt/loop.o || rm -f $mnt/loop.o
fi

# Adjust the owner and permissions

chown -R root.root $mnt/*
chmod -R og=rX $mnt/*

# Umount the floppy and copy it to a compressed raw disk image file.
df $mnt
$ROOTCMD umount $mnt
rmdir $mnt

(rm -f root$revext.bin ;true)
if [ "$revext" = lowmem ]; then
	cp $floppy root$revext.bin
else
	gzip -9f <$floppy >root$revext.bin
fi

ls -l root$revext.bin
rm -f $floppy
exit 0
