#!/bin/sh
# Low mem initrd Disk maker. Enrique Zanardi, June 1998
# This is free software under the GNU General Public License.

set -e
set -v
set -x

export LANG=C

if [ $# != 0 ]; then
echo "Usage: "$0" " 1>&2
        exit -1
fi

PROGRAM=utilities/lowmemrd/linuxrc

# Set this to the block device for the floppy disk.
floppy=/var/tmp/floppy-image.$$

mnt=/var/tmp/mnt.lowmemrd

(cd utilities/lowmemrd; make)

# Try to unmount anything that should not be mounted.
(umount $mnt; umount $floppy; true)2>/dev/null >/dev/null

mkdir -p $mnt

blocks=`/bin/ls -l $PROGRAM |awk '{print $5}'`
blocks=`expr ${blocks} / 1024 + 30`

# Zero the entire disk, so that when I compress the raw disk image,
# unused blocks will compress well.
dd if=/dev/zero of=$floppy bs=1k count=${blocks}

# Make a Minix filesystem.
/sbin/mkfs.minix -n14 -i 380 $floppy ${blocks}

# Mount the disk.
mount -t minix -o loop $floppy $mnt

mkdir $mnt/dev
(cd $mnt/dev; /dev/MAKEDEV fd0 fd1 hda hdb hdc hdd sda sdb sdc sdd)
mknod $mnt/dev/tty1 c 4 1
mkdir $mnt/proc
mkdir $mnt/mnt
chmod 555 $mnt/proc
cp $PROGRAM $mnt/linuxrc
chmod 755 $mnt/linuxrc

# Adjust the owner and permissions

chown -R root.root $mnt/*

# Umount the floppy and copy it to a compressed raw disk image file.
df $mnt
umount $mnt
rmdir $mnt

(rm -f lowmemrd.bin ;true)
gzip -9f <$floppy >lowmemrd.bin
ls -l lowmemrd.bin
rm -f $floppy
exit 0
