#!	/bin/bash

# Abort on any non-zero return.
set -e

# Verbose shell execution.
#set -v
set -x

umask 022

export LANG=C

# dpkg needs this.
export PATH=/sbin:/usr/sbin:$PATH

if [ $# -ne 2 ]; then
	echo "Usage:	"$0 "debian-archive-directory debian-version" 1>& 2
	cat 1>&2 << EOF

	Creates a new base archive.

	debian-archive-directory: the local copy of the Debian archive.
	debian-version: version of the Debian release

EOF
	exit -1;
fi

. common.sh

# Set this to the location of the package archive.
archive=$1

version=`echo $2 | sed -e 's/\./_/'`

# Temporary directories
B=/var/tmp/base-tmp-$$
P=/var/tmp/partial-tmp-$$

# The home of the scripts used by this script.
scripts=`pwd`/scripts/basedisks

# PARTIAL_PACKAGES are an ugly kludge. The proper fix would be to move
# the needed files to base packages.
PARTIAL_PACKAGES=`cat $scripts/PARTIAL_PACKAGES_all \
 $scripts/PARTIAL_PACKAGES_${arch}`
if [ -n "$PARTIAL_PACKAGES" ]; then
  echo -e "WARNING: Some files from the following packages must be in the \n\
base system, but currently are not provided by any base package: \n\n\
$PARTIAL_PACKAGES\n"
fi

# Check to see if all the needed packages are in the archive.
exit=false
for i in $scripts/PACKAGES_all $scripts/PACKAGES_${arch} \
 $scripts/PARTIAL_PACKAGES_all $scripts/PARTIAL_PACKAGES_${arch}; do
	if [ ! -f $i ]; then
		echo "Can't open $i"
		exit=true
	fi
done
if $exit; then
	exit -1;
fi

# Expand the package names into full pathnames.
PACKAGE_PATHS=`make_paths \`cat $scripts/PACKAGES_all \
 $scripts/PACKAGES_${arch}\``
if [ $? -ne 0 ]; then
	exit -1;
fi
PARTIAL_PACKAGE_PATHS=`make_paths $PARTIAL_PACKAGES`
if [ $? -ne 0 ]; then
	exit -1;
fi

rm -f -r $B $P # Paranoia.

# TODO It should extract only essential packages and the libs those need.
for i in $PACKAGE_PATHS; do
	# echo Extracting $i 1>&2
	dpkg-deb --extract $i $B
done

for i in $PARTIAL_PACKAGE_PATHS; do
	# echo Extracting $i 1>&2
	dpkg-deb --extract $i $P
done

(cd $P; tar -cf - `cat $scripts/PARTIAL_PACKAGE_FILES_all \
 $scripts/PARTIAL_PACKAGE_FILES_${arch}`) \
 |(cd $B;tar xvlpf -)

rm -f -r $P &

# Miscellaneous stuff normally done by the postinst scripts.
if [ ! -f $B/usr/bin/perl -a -f $B/usr/bin/perl.dist ]; then
	(cd $B/usr/bin; mv perl.dist perl)
fi

echo -n > $B/var/lib/dpkg/status
echo -n > $B/var/lib/dpkg/available

case "$arch" in
	alpha)
		(cd $B/dev; /dev/MAKEDEV loop std generic hdc hdd hde hdf hdg hdh sdc sdd sde sdf sdg sdh )
		;;
	i386)
		(cd $B/dev; /dev/MAKEDEV generic-i386 loop hdc hdd sdc sdd sde sdf sdg sdh scd-all isdn-io sonycd mcd mcdx cdu535 lmscd sbpcd aztcd bpcd)
		;;
	m68k)
		(cd $B/dev; /dev/MAKEDEV std generic-m68k hdc hdd sdc sdd sde sdf adc add ade adf loop scd-all)
		;;
	powerpc)
		(cd $B/dev; /dev/MAKEDEV generic-powerpc loop sdc sdd sde sdf sdg sdh isdn-io )
		;;
	sparc)
		(cd $B/dev; /dev/MAKEDEV generic-sparc loop sdc sdd sde sdf sdg sdh )
		(cd $B/dev; ln -s sunmouse mouse )
		# for serial console on 2.0 kernel
		# (not created by MAKEDEV anymore)
		mknod $B/dev/cua0 c 5 64
		mknod $B/dev/cua1 c 5 65
		;;
	*)
		(cd $B/dev; /dev/MAKEDEV generic )
		(cd $B/dev; /dev/MAKEDEV local )
		;;
esac
(cd $B/dev; /dev/MAKEDEV initrd rtc )
#mknod $B/dev/initrd b 1 250
#mknod $B/dev/ram0 b 1 0
#mknod $B/dev/rtc b 10 35
# ensure /dev/console is compatible with 2.2 kernel (will be overwritten by
# dbootstrap if installing for 2.0 kernel)
rm -f $B/dev/console
mknod $B/dev/console c 5 1

case "$arch" in
	alpha)
		libc6pack="ldconfig libc6.1"
		;;
	*)
		libc6pack=libc6
		;;
esac

(cd $B; chroot $B sbin/ldconfig.new)
trap "umount $B/proc" 0
chroot $B mount -t proc proc /proc

# [ED] Sparc installation requires step by step installation of ldso, base-files
#      libc6 & dpkg.
# BTW, make_paths shouldn't be called out of the directory where updates live !
# base-files & ldso have to be installed & configured before any other pkgs
corepkgs=`make_paths base-files base-passwd ldso`
(cd $B;dpkg --root=. --install --force-depends --force-auto-select $corepkgs)
# dpkg predepends on libc6 but can be configured anyway
corepkgs=`make_paths dpkg`
(cd $B;dpkg --root=. --install --force-depends --force-auto-select $corepkgs)
# libc6 fails to unpack before dpkg is configured (at least on sparc)
corepkgs=`make_paths $libc6pack`
(cd $B;dpkg --root=. --install --force-depends --force-auto-select $corepkgs)

(cd $B; 
  for package in $PACKAGE_PATHS; do
    dpkg --root=. --unpack --force-auto-select --force-depends \
         --force-overwrite $package
  done
)  

# Don't start any daemon.
mv $B/sbin/start-stop-daemon $B/sbin/start-stop-daemon.REAL
cp $B/bin/true $B/sbin/start-stop-daemon

# Miscellaneous stuff to avoid problems with the postinst scripts.
# Most of those should be fixed in the scripts.

# Set the default dselect method
echo "multicd multi_cd" >$B/var/lib/dpkg/cmethopt
chmod 644 $B/var/lib/dpkg/cmethopt

# FIXME: ppp insists that /var/run/syslogd.pid exist.
echo "1">$B/var/run/syslogd.pid
cp $B/usr/share/zoneinfo/Factory $B/etc/localtime
echo America/Los_Angeles > $B/etc/timezone # Avoid post-inst question.
echo > $B/etc/kbd/default.map # Avoid post-inst question.
if [ -f $B/var/lib/dpkg/info/pcmcia-cs.postinst ]; then
	mv $B/var/lib/dpkg/info/pcmcia-cs.postinst $B 
	cp $scripts/pcmcia-cs.postinst $B/var/lib/dpkg/info/pcmcia-cs.postinst
	pcmcia=yes
fi

# boot-floppies_2.1.6 doesn't include dpkg-mountable
# # dpkg-mountable_0.7 uses diagnostic.pm in his setup and install scripts, but
# # perl-base_5.004.04-6 doesn't provide it.
# for i in install setup ; do
# 	grep -v "^use diagnostics;$" \
# 		$B/usr/lib/dpkg/methods/mountable/$i >$B/$i
# 	mv $B/$i $B/usr/lib/dpkg/methods/mountable/$i
# 	chmod 755 $B/usr/lib/dpkg/methods/mountable/$i
# 	chown root.root $B/usr/lib/dpkg/methods/mountable/$i
# 
# done

(cd $B;yes N | dpkg --root=. --configure --pending --force-configure-any \
 --force-depends ; )
chroot $B umount /proc
trap 0

# Copying fonts not included in kbd-data.
for font in `find $scripts/../rootdisk/consolefonts -type f`; do
       cp -f $font $B/usr/share/consolefonts
       gzip -9f $B/usr/share/consolefonts/`basename $font` || true
done

if [ x$pcmcia = xyes ]; then
	mv $B/pcmcia-cs.postinst $B/var/lib/dpkg/info/
fi

mv $B/sbin/start-stop-daemon.REAL $B/sbin/start-stop-daemon
echo Factory > $B/etc/timezone
rm -f $B/usr/share/zoneinfo/localtime
rm -f $B/etc/kbd/default.map*
# FIXME: ppp insists that /var/run/syslogd.pid exist.
rm -f $B/var/run/syslogd.pid
# FIXME:
sed -e 's,/sbin/setup.sh,/root/setup.sh,' \
	<$B/etc/init.d/rcS >$B/etc/init.d/rcS.tmp
mv $B/etc/init.d/rcS.tmp $B/etc/init.d/rcS
chmod a+x $B/etc/init.d/rcS

# will be copied from or created by the root disk
rm -f $B/etc/{conf.modules,modules} $B/etc/init.d/network
if [ x$pcmcia = xyes ]; then
	rm -f $B/etc/pcmcia.conf $B/etc/pcmcia/serial.opts \
	  $B/etc/pcmcia/cdrom.opts $B/etc/pcmcia/network.opts
fi

(cd $B; dpkg --root=. -l) >base-contents

echo '#! /bin/sh

echo "WARNING!  You are attempting to boot an unconfigured base system.
You need to configure it before proceeding.  To do this, you need
to reboot using the Debian Rescue disk and select the
\"Configure the Base System\" option from the installation menu.

Please make sure that the Debian Rescue Disk is in the boot
floppy drive and press <ENTER> to reboot:
"

read input
reboot' > $B/sbin/unconfigured.sh

chmod 755 $B/sbin/unconfigured.sh

rm -f $scripts/new_root_home/*~ $scripts/new_root_home/.*~
(cd $scripts/po ; ./build.sh)
mv $B/root/.profile $B/root/.profile.real
# For root, override the language defined in /etc/environment
echo -e "\nexport LANG=C" >>$B/root/.bashrc
(cd $scripts/new_root_home ; tar cf - . --exclude CVS)|(cd $B/root ; tar -xf - )
chown -R root.root $B/root

(find $B -name '*.dpkg-old' -exec rm -f \{\} \; ; true)
rm -f $B/var/lib/dpkg/status-old $B/var/lib/dpkg/available-old

(cd $B; tar clf - .)| gzip --best > base${version}.tgz

rm -f -r $B &

case $arch in
    i386)
	./utilities/floppy_split base${version}.tgz base12 1200
	./utilities/floppy_split base${version}.tgz base14 1440
	;;
    m68k)
	./utilities/floppy_split base${version}.tgz base14 1440
	./utilities/floppy_split base${version}.tgz base72 720
	;;
    *)
	./utilities/floppy_split base${version}.tgz base14 1440
	;;
esac
exit 0
