// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: xpm.h,v 1.2 1998/08/27 04:10:36 jgg Exp $
/* ######################################################################

   XPM - XPM Cover class

   Much of the XPM smarts are hidden into the Graphics GC, this only
   serves as a cover to allow consistant userland manipulation.
   
   The GraphicGC is responsible for being able to read XPM's from disk and
   memory blocks as well as being able to render them on the screen. With
   X this is all handled by libxpm. Other platforms will likely need to 
   use custom XPM routines.
   
   We provide a preload mechanism that is designed to load the image in
   from disk and store it in memory. This is needed so applications can
   have size information from the XPM, and to speed things up when using
   X (X can't directly use the xpm, needs pixmap format data first)
   
   ##################################################################### */
									/*}}}*/
// Header section: deity
#ifndef DEITY_XPM_H
#define DEITY_XPM_H

#ifdef __GNUG__
#pragma interface "deity/xpm.h"
#endif  

#include <string>
#include <deity/graphics.h>

class XPMImage
{
   public:

   // Simple class to allow the GC to be able to clean up its attached data
   class Data
   {
      public:
      virtual ~Data();
   };

   /* Simple class to allow the GC to be able to preload the image data
      in a usefull format */
   class PreloadData
   {
      public:
      
      Point Dim;
      virtual ~PreloadData();
   };
   
   private:
   
   // Locations
   string File;
   const char **Image;
   
   public:

   // GC private data
   Data *DrawData;
   PreloadData *iPreload;

   // Accessors
   inline bool IsFile() {return !File.empty();};
   inline string FileName() {return File;};
   inline const char **XPMData() {return Image;};
   Point Dim();
   bool Preload();
   
   // Constructors for memory and file xpms
   XPMImage(char **Image);
   XPMImage(const char **Image);
   XPMImage(string File);
   ~XPMImage();
};

#endif
