// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include <qframe.h>
#include "Canvas.h"
#include "HLineRenderer.h"

HLineRenderer::HLineRenderer( Canvas*     canvas,
                              int         clipWidth,
                              QObject*    parent,
                              const char* name )
        : Renderer( canvas, clipWidth, parent, name )
{
    _frame = new QFrame( canvas->clip() );
    _frame->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    _frame->setLineWidth( 2 );
    _frame->resize( clipWidth, 2 );
    canvas->registerWidget( this, _frame );
    
    resize( clipWidth, 2 );
}

void HLineRenderer::endOfData()
{
}

bool HLineRenderer::redraw()
{
    if ( !_needRedraw ) return FALSE;
    
    _frame->setGeometry( 0, 0, clipWidth(), 2 );
    resize( clipWidth(), 2 );

    _needRedraw = FALSE;

    return TRUE;
}
