;;; NO SYMBOLS DEFINED HERE
;;; LOAD RETURN: function PROTO (<function> <file>)
;;;      RETURN: function PROTO (<function> <stream>)
;;;      RETURN: new stream
;;;      ASIDE : write SGML representation into <file>

(let*
    ((symstr (memoize symbol->string eq?))
     (tag->string (lambda (token) (symstr (token-gi token))))
     (arg->name (lambda (arg) (symstr (arg-name arg))))
     (to-strings
      (lambda (lst)
	(let ((f (lambda (v)
		   (cond
		    ((string? v) v)
		    ((symbol? v) (symbol->string v))
		    ((number? v) (number->string v))
		    (else "unknown")))))
	  (if (pair? lst) (map f lst) (list (f lst))))))
     (arg->val (lambda (arg)
		 (case (arg-type arg)
		   ((DATA CDATA) (plain-tr-string (arg-val arg)))
		   ((OUTPUT) (arg-val arg))
		   ((TOKEN) (strings-join (to-strings (arg-val arg)) " "))
		   (else (error "[sgml-write]arg->val"
				"unhandled arg type" (arg-type arg))))))
     (writer
      (lambda (port)
	(lambda (token)
	  (case (token-type token)
	    ((PI) (display "<?" port)
		  (display (data-token-data token) port)
		  (display ">" port))
	    ((DATA) (display (plain-tr-string (data-token-data token)) port))
	    ((OUTPUT) (display (data-token-data token) port))
	    ((STARTTAG)
	     (display #"\n<" port) (display (tag->string token) port)
	     (do ((args (token-args token) (cdr args)))
		 ((null? args))
	       (if (not (eq? (arg-type (car args)) 'IMPLIED))
		   (let ((arg (car args)))
		     (display #"\n  " port)
		     (display (arg->name (car args)) port)
		     (display "=\"" port)
		     (display (arg->val arg) port)
		     (display #\" port))))
	     (display #">\n" port))
	    ((ENDTAG) (display #"\n</" port)
		      (display (tag->string token) port)
		      (display #">\n" port))
	    (else #t))
	  token))))

  (lambda (outfile)
    (lambda (in-stream)
      (if (and outfile (not (string=? outfile "-")))
	  (let ((port (open-output-file outfile)))
	    (hook 'doc-postprocess 'add
		  (lambda x (close-output-port port) x))
	    (stream-map (writer port) in-stream))
	  (stream-map (writer port) in-stream)))))
