// --------------------------------------------------------------------------
// SPARCstation specific audio interface. (very poor)
// --------------------------------------------------------------------------

#include "AudioDriver.h"

const char AudioDriver::AUDIODEVICE[] = "/dev/audio";

AudioDriver::AudioDriver()
{
    outOfOrder();
}

AudioDriver::~AudioDriver()
{
    close();
}

void AudioDriver::outOfOrder()
{
    // Reset everything.
    errorString = "None";
    audioHd = (-1);
}

bool AudioDriver::isThere()
{
    return (access(AUDIODEVICE,W_OK)==0);
}

bool AudioDriver::open(const AudioConfig& inConfig)
{
    if ((audioHd=::open(AUDIODEVICE,O_WRONLY,0)) == (-1))
    {
        perror(AUDIODEVICE);
        errorString = "ERROR: Could not open audio device.\n       See standard error output.";
        return false;
    }

    // Copy input parameters. May later be replaced with driver defaults.
    config = inConfig;

#ifdef CHECKFORSPEAKERBOX  
    int hwdevice;
    if ( ioctl(audioHd,AUDIO_GETDEV,&hwdevice) == (-1))
    {
        perror(AUDIODEVICE);
        errorString = "AUDIO: No audio hardware device installed.";
        return false;
    }
    if ( hwdevice != AUDIO_DEV_SPEAKERBOX )
    {
        audioHd = -1;
        perror(AUDIODEVICE);
        errorString = "AUDIO: Speakerbox not installed/enabled.";
        return false;
    }
#endif
	
    // Choose the nearest possible frequency.
    int dbrifreqs[] = 
    {
        8000, 9600, 11025, 16000, 18900, 22050, 32000, 37800, 44100, 48000, 0
    };
    int dbrifsel = 0;
    int dbrifreqdiff = 100000;
    int dbrifrequency = config.frequency;
    do
    {  
        int dbrifreqdiff2 = config.frequency - dbrifreqs[dbrifsel];
        dbrifreqdiff2 < 0 ? dbrifreqdiff2 = 0 - dbrifreqdiff2 : dbrifreqdiff2 += 0;
        if ( dbrifreqdiff2 < dbrifreqdiff )  
        {
            dbrifreqdiff = dbrifreqdiff2;
            dbrifrequency = dbrifreqs[dbrifsel];
        }
        dbrifsel++;
    }  while ( dbrifreqs[dbrifsel] != 0 );
    config.frequency = dbrifrequency;
	
    // Only poor audio capabilities at 8-bit.
    // Sparcstations 5 and 10 tend to be 16-bit only at rates above 8000 Hz.
    config.precision = AudioConfig::BITS_16;
    config.encoding = AudioConfig::SIGNED_PCM;
    // Dumb mode. Dumb default. See below.
    config.blockSize = (config.frequency>>2);
    
    audio_info myaudio_info;
    if ( ioctl(audioHd,AUDIO_GETINFO,&myaudio_info) == (-1))
    {
        perror(AUDIODEVICE);
        errorString = "AUDIO: Could not get audio info.\n       See standard error output.";
        return false;
    }
    AUDIO_INITINFO( &myaudio_info );
    
    //myaudio_info.play.buffer_size = config.blockSize;  // does not work (?)
    myaudio_info.play.sample_rate = config.frequency;
    if (config.channels == AudioConfig::STEREO)
        myaudio_info.play.channels = 2;
    else  // if (config.channels == AudioConfig::MONO)
        myaudio_info.play.channels = 1;
    myaudio_info.play.precision = config.precision;
    myaudio_info.play.encoding = AUDIO_ENCODING_LINEAR;
    myaudio_info.output_muted = 0;
    if ( ioctl(audioHd,AUDIO_SETINFO,&myaudio_info) == (-1))
    {
        perror(AUDIODEVICE);
        errorString = "AUDIO: Could not set audio info.\n       See standard error output.";
        return false;
    }

    // Unsupported.
    config.fragments = 1;
    config.fragSizeExp = 0;

    errorString = "OK";
    return true;
}

void AudioDriver::close()
{
    if (audioHd != (-1))
    {
        reset();
        ::close(audioHd);
        outOfOrder();
    }
}

void AudioDriver::play(void* buffer, unsigned long int bufferSize)
{
    if (audioHd != (-1))
    {
        write(audioHd,(char*)buffer,bufferSize);
    }
}
