// Copyright (c) 1997 Albrecht Kleine   All rights reserved
// file version #200

//-------------------------- constrains --------------------------------------
#ifdef JDK102
 #undef EXCEPTIONS_BY_SIGNALS
 #undef USEASM
#endif

#ifndef TRY_FAST_INVOKE
  #undef FAST_NATIVE102STYLE
#endif

//-------------------------- debug messages ----------------------------------
#ifdef DEBUG
  #ifdef USE_SYSLOG
    // dprintf is a function definition, see below.
    #define dflush while(0) fflush
  #else
    #define dprintf fprintf
    #define dflush  fflush
  #endif
  #undef USEASM
  #undef DEBUG_INV
#else
  #define dprintf while(0) fprintf
  #define dflush  while(0) fflush
#endif
#ifndef USE_SYSLOG
  #define iprintf while(0) printf
#endif

//
#define LOCSTART 40	// offset of begin of memory for local variables
			// compare layout description in InvokeCompiledMethod_Hook() !!

#ifndef TYAASM_S

void lprintf(char *fmt, ...);
#ifdef USE_SYSLOG
void iprintf(char *fmt, ...);
#endif
void lopen(void);
void lclose(void);
#ifdef DEBUG
  #ifdef USE_SYSLOG
    void dprintf (FILE *ignore, char *fmt, ...);
  #endif
#endif


//-------------------------- structures -------------------------------------
struct iptrans
{
   unsigned char* java;		// 1:1 mapping of adresses
   unsigned char* x86;		// (from bytcode to x86 code and vice versa)
   int isdest;			// TRUE if address is a jump destination
} ;

struct back
{
   unsigned char* java;
   unsigned char* x86;
   int javadist;
   int currcnt;
} ;


struct CINFO
{
   unsigned char *cptr;
   unsigned char *codebase;
   unsigned char *bptr;
   struct methodblock* mb;

   struct iptrans* iptab;
   int ipcnt;
   
   struct back* backp;
   int backcnt;

   unsigned char** start;
   unsigned char** end;
   unsigned char** handler;
   ClassClass **exclazz;
   ExecEnv *ee;
   
   int wide;		// not yet finished (FIXME)
   int isinline;	// compiling an inlined method
   int inlineerr;	// do NOT allow compiling of inlined methods
   int maxspace;	// size of code array
   int resspace;	// reserved space at end
} ;

#define WORD unsigned short int
#define BYTE unsigned char
#define SIS4 (sizeof(stack_item))

//------------------------- recode and its helpers ----------------------------------
 int recode(int j,Classjava_lang_Class *klass,struct CINFO* cinfo);

 int GetMethNr(struct methodblock *mbp);
 int GetMethodNumber(struct methodblock* mb,Classjava_lang_Class *klazz);

 void CompAddFieldOffset(struct fieldblock *fbp,struct CINFO* cinfo);
 void Comp_PUSH_LocalVar(int wo,struct CINFO* cinfo);
 void Comp_PUSH_LocalVarToStack(int wo,struct CINFO* cinfo);
 void Comp_POP_StoreLocalVar(int wo,struct CINFO* cinfo);
 void Comp_INC_LocalVar(int wo,int inc,struct CINFO* cinfo);
 void CompVergleich(unsigned char code,int *j,unsigned short int opcode86,struct CINFO* cinfo);
 void Comp87Vergleich(unsigned char code,struct CINFO* cinfo);
 void Comp87ToInteger(unsigned char code,struct CINFO* cinfo);
 void MakeStackRevInstruction(struct methodblock *mb,int xstatic);

 void* GetBlock(int *nr,int isfield,unsigned char code,int *pj,Classjava_lang_Class *klass,
				 struct CINFO* cinfo,int quick);

 int  getint32( int *j,struct CINFO* cinfo);
 int  getint16U(int *j,struct CINFO* cinfo);
 int  getint16S(int *j,struct CINFO* cinfo);


 void BackPatchJumpDists(struct CINFO* cinfo);

// void ShowCompiledCode(unsigned char* code,int size);
// void ShowJavaByteCode(unsigned char* code,int size);
 void ShowPreInvokeInfo(struct methodblock *mb,int args_size,struct execenv *ee,int noncom);
 void ShowPostInvokeInfo(struct methodblock *mb,struct execenv *ee,int nocom);


 int  ProcessExceptionTab(struct methodblock *mb,struct CINFO* cinfo);
 int  CompiliereMethode(struct methodblock* mb, struct CINFO *cinfo,ExecEnv *ee);
 bool_t /* long long*/ JITCompileMethod(struct methodblock *mb, struct execenv *ee);


 bool_t MYInvokeCompiledMethod(JHandle *thiso, struct methodblock *mb, 
				     int args_size, struct execenv *ee);

 bool_t MyIsInstanceOf(ClassClass *dcb,ExecEnv *ee,HObject * h);
 HObject *MyArrayAlloc(int type,int len);
 HObject *MyObjAlloc(ClassClass *dcb);

 void* FastInvCheck32(struct execenv *ee,struct methodblock *mbpcalled,stack_item *sp);
 void* FastInvCheck64(struct execenv *ee,struct methodblock *mbpcalled,stack_item *sp);
 void* FastInvNoCheck32(struct execenv *ee,struct methodblock *mbpcalled,stack_item *sp);
 void* FastInvNoCheck64(struct execenv *ee,struct methodblock *mbpcalled,stack_item *sp);

 long long CodeRunner32(ExecEnv *ee, struct methodblock *mb, int *args);
 long long CodeRunner64(ExecEnv *ee, struct methodblock *mb, int *args);
 long long CodeRunner64_withDummies(int d1, int d2,ExecEnv *ee, struct methodblock *mb, int *args);
 long long CodeRunner32_withDummies(int d1, int d2,ExecEnv *ee, struct methodblock *mb, int *args);

 void debughelper(void *stacA,void *stacB,void *stacC);

 void ReverseCopyViaReversedScript(stack_item *loc,char *xx,int anz,stack_item *args,int maxvaroffs);
 void* ReverseCopyViaScript(stack_item *loc,char *xx,int anz,stack_item *args);

 int IgnoreBadClass(Classjava_lang_Class *klazz,Classjava_lang_Class *clazz);
 int CheckException(struct execenv *ee,int code);
 void StOvExcHandler (void);

 long long lldiv_wrapper(long long x,long long z);
 long long llmul_wrapper(long long x,long long z);
 long long llrem_wrapper(long long x,long long z);

int Arrstex();
long long CRun32asm(void *ee,int *args,void *f);
long long CRun64asm(void *ee,int *args,void *f);
struct methodblock *RTGetIMeth(HObject *o,ClassClass *klassX,int u);

//-----------------------------------------------------------------------------------------

void InitializeForCompiler_Hook(ClassClass *class);
bool_t InvokeCompiledMethod_Hook(JHandle *o, struct methodblock *mb, int args_size, struct execenv *ee);
long CompileClass_Hook(ClassClass *class);
long CompileClasses_Hook(Hjava_lang_String *hclname);
void* CompilerFreeClass_hook(ClassClass *clazz);
int PCinCompiledCode_Hook(unsigned char *pc,struct methodblock *mb);
void CompiledCodeSignalHandler_hook(int sig,void *info,void *uc);
unsigned char *CompiledCodePC_Hook(JavaFrame *frame,struct methodblock *mb);
void Enable_hook(void);
void Disable_hook(void);
JHandle *CompilerCommand_hook(JHandle *x);


#define DEFCOMPILEDSIZE 20000	// most methods are below this value...
#define MAXCOMPILEDSIZE 1000000	// ...but for some we make an exception

#define INLINE_ERROR    -1000	// error during inline compiling
#define NOSPACE_ERROR   -2000	

// --------------------------------------------------------------------------
// compare to memory layout sheet in tya.c (new in tya 0.8)
#define SIZEOFJMP86      5	// 5 because  sizeof byte + sizeof int64    [or   CB(),CL()]


#define DIVZEROHANDSIZE	4	// sizeof exception preparation code
#define ARROUTOFFSIZE	4
#define NEGARRSIZESIZE  4
#define NULLPTRSIZE	4
#define OUTOFMEMSIZE	4
#define ARRAYSTORESIZE	4
#define CLASSCASTSIZE	4
#define INVOKEDEXSIZE	4
#define ATHROWEXSIZE	4

#define ALLEXCEPTSIZE	(DIVZEROHANDSIZE\
	  		+ARROUTOFFSIZE\
			+NEGARRSIZESIZE\
			+NULLPTRSIZE\
			+OUTOFMEMSIZE\
			+ARRAYSTORESIZE\
			+CLASSCASTSIZE\
			+INVOKEDEXSIZE\
			+ATHROWEXSIZE)

#define COMMONEXSIZE	16	// the common part for 9 others
#define RESERVED1 	4	// sizeof int
#define RESERVED2 	4	// sizeof int
#define ENTRYPOINT 	64	// start of code

#if ALLEXCEPTSIZE+COMMONEXSIZE+RESERVED1+RESERVED2 > ENTRYPOINT
#error bad ENTRYPOINT setting
#endif


 

//---------------------------------------------------------------------------
 void SimpleExcHandler(void);
 void ExecExcep(ExecEnv *ee,HObject *exception_obj);
 char *CompExceptionHandlerPart1(struct CINFO* cinfo);
 void CompExceptionHandlerPart2(struct CINFO* cinfo);
 void PrepareExceptions(void);

 void CompTriggerLONGDivZeroException(struct CINFO* cinfo);
 void CompTriggerDivZeroException(struct CINFO* cinfo);
 void CompTriggerArrOutOfBoundsException(struct CINFO* cinfo,int tmpreg);
 void CompTriggerNegArraySizeException(struct CINFO* cinfo);
 void CompTriggerNullPointerException(struct CINFO* cinfo, int reg);
 void CompTriggerNullPointerException2(struct CINFO* cinfo, int reg);
 void CompTriggerOutOfMemoryException(struct CINFO* cinfo);
 void CompTriggerArrayStoreException(struct CINFO* cinfo);
 void CompTriggerClassCastException(struct CINFO* cinfo);
 void CompTriggerAthrowException(struct CINFO*cinfo);
 void CompTriggerExceptionFromInvoked(struct CINFO* cinfo);
//---------------------------------------------------------------------------



#ifndef VERBOSE_ASM86
 #define CB(BYTE) *cinfo->cptr++=(unsigned char)BYTE
 #define CW(word) *((WORD*)cinfo->cptr)++=(WORD)(word)
 #define CL(LONG) *((unsigned long*)cinfo->cptr)++=(unsigned long)(LONG)
 #define emit( x )
#else
 #define CB(BYTE) (*cinfo->cptr++=(unsigned char)BYTE,fprintf(stderr,"%s \t%02x\n",#BYTE,BYTE))
 #define CW(word) (*((WORD*)cinfo->cptr)++=(WORD)(word),fprintf(stderr,"%s\n",#word))
 #define CL(LONG) (*((unsigned long*)cinfo->cptr)++=(unsigned long)(LONG),fprintf(stderr,"%s\n",#LONG))
 #define emit( x ) fprintf x
 #define se stderr
 extern const char * rname[];
 extern const char * rname8[];
 extern const char * sibdecode(int );
 int decode_bytecode(unsigned char *code);
#endif          



////////////////////////////////////////////////////////////////////////////////////
// Machine code data is preassembled using a Intl style syntax, no gnu-asssembler //
////////////////////////////////////////////////////////////////////////////////////
#define EAX 0
#define ECX 1
#define EDX 2
#define EBX 3
#define ESP 4
#define EBP 5
#define ESI 6
#define EDI 7
#define R8_AL 0
#define R8_CL 1
#define R8_DL 2
#define R8_BL 3



// FIXME: should rearrange that stuff....


#define INC_AX     0x40      /* inc eax */
#define INC_BX     0x43      /* inc ebx */
#define DEC_BX     0x4B      /* dec ebx */
#define DEC_AX     0x48      /* dec eax */
#define INC_DI     0x47      /* inc edi */
#define INC_SI     0x46      /* inc esi */
#define DEC_DI     0x4F      /* dec edi */
#define DEC_SI     0x4E      /* dec esi */

#define PREF_32    0x66      /* seg attr prefix  */
#define NOP        0x90      /* do nothing */
#define NOP2       0x9090    /* do nothing twice ;-) */

#define MOV_BXAX   0xC389    /* mov ebx,eax */
#define MOV_AXDX   0xC28B    /* mov eax,edx */
#define MOV_CXAX   0xC189    /* mov ecx,eax */
#define MOV_BXDX   0xDA8B    /* mov ebx,edx */
#define MOV_BXCX   0xD98B    /* mov ebx,ecx */
#define MOV_CXDX   0xCA8B
#define MOV_DXBX   0xDA89
#define MOV_AXBX   0xD889
#define MOV_AX_SP    0xC48B

#define ADD_DXDX   0xD203
#define ADD_BXDX   0xDA03
#define ADD_BXAX   0xD803    /* add ebx,eax */
#define ADC_CXDX   0xCA13    /* adc ecx,edx */
#define SBB_AXBX   0xC31B    /* sbb eax,ebx */
#define SUB_CXDX   0xCA2B    /* sub ecx,edx */
#define SBB_CXDX   0xCA1B    /* sbb ecx,edx */

#define MOV_CX_MBX_8 0x4B8B
#define MOV_MCX_AX 0x0189
#define MOV_MCX_DX 0x1189	
#define ADD_CX     0xC183


#define OR_AXCX    0xC10B    /* or eax,ecx */
#define XOR_AXCX   0xC133    /* xor eax,ecx */
#define AND_AXCX   0xC123    /* and eax,ecx */
#define OR_CLCL    0xC90A    /* or cl,cl */
#define OR_DXBX    0xD30B    /* or edx,ebx */
#define XOR_DXBX   0xD333    /* xor edx,ebx */
#define AND_DXBX   0xD323    /* and edx,ebx */


#define OR_AXBX    0xC30B    /* or eax,ebx */
#define AND_AXBX   0xC323    /* and eax,ebx */
#define XOR_AXBX   0xC333    /* xor eax,ebx */
#define XOR_BXBX   0xDB33    /* xor ebx,ebx */


#define ADD_SP_MBP_8 0x6503
#define SUB_SP_MBP_8 0x652B
#define SUB_SPDX    0xd429
#define SUB_SPBX    0xE32B   /* sub esp,ebx */
#define SUB_SP_BYTE 0xEC83   /* sub esp,XX */
#define TEST_SP_LONG 0xC4F7  /* test esp,yyyyyyyy */
#define TEST_BX      0xC3F7

#define MOV_BX_MAX_8 0x588B
#define MOV_BX_MAX 0x188B



#define MOV_AX_MAX_32 0x808B   /* mov eax,[eax+yyyyyyyy] */
#define MOV_AX_MAX_8 0x408B
#define MOV_AX_MAX 0x008B


//#define MOV_MCX_8_DX 0x8951 buggy cmp *eans/prob memo
#define MOV_MCX_8_DX 0x5189
#define	CMP_MBP_8_LONG 0x7D83



#define MOV_BX_MBX 0x1b8b    /* mov ebx,[ebx] */
#define MOV_DX_MBX 0x138b    /* mov edx,[ebx] */



#define ADD_MBP_32_LONG 0x8581 /* add [ebp+xxxxxxxx],yyyyyyyy */
#define ADD_MBP_8_LONG 0x4581  /* add [ebp+xx],yyyyyyyy */
#define ADD_MBP_8_BYTE 0x4583  /* add [ebp+xx],yy */


#define CMP_MBX_8      0x7B81  /* cmp [bx+xx],yyyyyyyy */



#define LEAVE_RET  0xC3C9    /* leave stackframe / return */
#define ENTER      0xC8      /* enter stackframe xxxx yy */
#define LOOP       0xE2      /* loop .. */

#define MOV_AX     0xB8      /* mov eax,yyyyyyyy */
#define MOV_BX     0xBB      /* mov eax,yyyyyyyy */
#define MOV_CX     0xB9      /* mov ecx,yyyyyyyy */
#define MOV_DX     0xBA

#define MOV_MBP_8_AL  0x4588 /* mov [ebp+yy],al */
#define MOV_MBP_8_AX  0x4589 /* mov [ebp+yy],eax */
#define MOV_MBP_32_AX 0x8589 /* mov [ebp+yyyyyyyy],eax */

#define MOV_AL_MBP_8  0x458A /* mov al,[ebp+yy] */
#define MOV_AX_MBP_8  0x458B /* mov eax,[ebp+yy] */
#define MOV_AX_MBP_32 0x858B /* mov eax,[ebp+yyyyyyyy] */

#define MOV_BX_MBX_8  0x5B8B /* mov ebx,[ebx+yy] */
#define MOV_BX_MBX_32 0x9B8B /* mov ebx,[ebx+yyyyyyyy] */

#define MOV_AX_MBX_8  0x438B /* mov eax,[ebx+yy] */
#define MOV_AX_MBX_32 0x838B /* mov eax,[ebx+yyyyyyyy] */
#define MOV_DX_MBX_32 0x938B /* mov edx,[ebx+yyyyyyyy] */

#define MOV_CX_MBX_8  0x4B8B /* mov ecx,[ebx+yy] */
#define MOV_CX_MBP_8  0x4D8B /* mov ecx,[ebp+yy] */
#define MOV_DX_MBP_8  0x558B /* mov edx,[ebp+yy] */
#define MOV_BX_MBP_8  0x5D8B /* mov ebx,[ebp+yy] */


#define OR_MBP_8_BYTE 0x4D80
#define MOV_MBP_8_SI  0x7589
#define MOV_MBP_8_DI  0x7D89
#define MOV_SI_MBP_8  0x758B
#define MOV_DI_MBP_8  0x7D8B

#define MOV_DIBX      0xFB8B /* mov edi,ebx */
#define MOV_SIBX      0xF38B /* mov esi,ebx */
#define MOV_DI_MBX_8  0x7B8B /* mov edi,[ebx+yy] */
#define MOV_MBX_8_DI  0x7B89 /* mov [ebx+yy],edi */
#define CLD_STOSD     0xABFC /* cld / stosb */
#define STOSD         0xAB   /* stosd */

#define XCHG_AXCX     0x91   /* xchg eax,ecx */
#define XCHG_AXDX     0x92   /* xchg eax,edx */
#define XCHG_AXBX     0x93   /* xchg eax,ebx */

#define MOV_CXBX   0xCB8B    /* mov ecx,ebx */
#define MOV_DXAX   0xD08B    /* mov edx,eax */

#define MOV_MBX_LONG 0x03C7
#define MOV_MBX_DX 0x1389    /* mov [ebx],edx */
#define MOV_MBX_DL 0x1388    /* mov [ebx],dl */
#define MOV_MBX_CX 0x0B89    /* mov [ebx],ecx */

#define MOV_CX_MCX_8 0x498B  /* mov ebx,[ecx+yy] */

#define MOV_MBX_8_CX 0x4B89  /* mov [ebx+yy],ecx */
#define MOV_MBX_8_AX 0x4389  /* mov [ebx+yy],eax */

#define MOV_DL_MBX_8 0x538A  /* mov dl,byte ptr [ebx+yy] */
#define SHR_DX       0xEAC1  /* shr edx,yy */

#define SHR_BX     0xEBC1    /* shr ebx,yy */

#define MOV_BXBP   0xDD8B    /* mov ebx,ebp */

#define MOV_AX_MBX 0x038b    /* mov eax,[ebx] */
#define MOV_MBX_AX 0x0389    /* mov [ebx],eax */
#define MOV_CL_MBX 0x4B8A    /* mov cl,byte ptr [ebx] */


#define AND_CX     0xE181    /* and ecx,yyyyyyyy */
#define AND_CX_BYTE 0xE183   /* and ecx,yy */


#define AND_AL      0x24
#define AND_AX_LONG 0x25      /* and eax,yyyyyyyy */
#define AND_AX_BYTE 0xE083   /* and eax,yy */


#define NEG_AX     0xD8F7    /* neg ax */
#define OR_AX	   0x0d      /* or ax,... */
#define OR_AXAX    0xC00B    /* or ax,ax */
#define CMP_AXBX   0xD839    /* cmp eax,ebx */
#define CMP_CXAX   0xC139    /* cmp ecx,eax */
#define CMP_DXBX   0xDA39    /* cmp edx,ebx */						
#define CMP_BXAX   0xD83B    /* cmp ebx,eax */
#define CMP_DXAX   0xD03B    /* cmp edx,eax */
#define CMP_BXDX   0xDA3B    /* cmp ebx, edx */
#define CMP_AXCX   0xC13B    /* cmp eax,ecx */

#define OR_BXBX    0xDB0B    /* or ebx,ebx */
#define OR_DXDX    0xD20B    /* or ebx,ebx */
#define SHL_BX     0xE3C1
#define MOV_MBP_8_BX 0x5D89
#define ADD_BXBX   0xDB03
#define SUB_BX_LONG 0xEB81
#define SUB_BX_BYTE 0xEB83   /* sub ebx,XX */
#define ADD_BX_BYTE 0xC383   /* add ebx,XX */
#define ADD_BX_LONG 0xC381   /* add ebx,XXXXXXXX */


#define MOV_AXDI  0xF889
#define MOV_AXSI  0xF089
#define MOV_DIAX  0xC789
#define MOV_SIAX  0xC689
#define ADD_DI    0xc781       /* add di,yyyyyyyy */
#define ADD_SI    0xc681       /* add si,yyyyyyyy */


#define SHL_AX     0xE0C1    /* shl eax,... */
#define SHR_AX     0xE8C1    /* shr eax,... */
#define SHL_AXCL   0xE0D3    /* shl eax,cl */
#define SHR_AXCL   0xE8D3    /* shr eax,cl */
#define SAR_AXCL   0xF8D3    /* sAr eax,cl */
#define SAR_DXCL   0xFAD3
#define SHR_DXCL   0xEAD3

#define PREBYTE_0F  0x0F

#define SHLD_DXAXCL 0xC2A5
#define SHRD_DXAXCL 0xD0AD

#define SHR_CL      0xE9C0
#define ROR_CL      0xC9C0

#define SHL_AX_1   0xE0D1    /* shl eax,1 */
#define RCL_DX_1   0xD2D1    /* rcl edx,1 */
#define SAR_DX_1   0xFAD1    /* sAr edx,1 */
#define SHR_DX_1   0xEAD1    /* shr edx,1 */
#define RCR_AX_1   0xD8D1    /* rcr eax,1 */


#define XOR_DXDX   0xD233    /* xor edx,edx */
#define XOR_AXAX   0xC033    /* xor eax,eax */

#define ADD_AXAX   0xC003    /* add eax,eax */
#define ADD_AXDX   0xC203    /* add eax,edx */
#define ADD_AXBX   0xC303    /* add eax,ebx */
#define SUB_AXBX   0xC32B    /* sub eax,ebx */
#define SUB_AXDX   0xC22B    /* sub eax,edx */
#define SUB_BXAX   0xD82B    /* sub ebx,eax */
#define	ADDAX      0xC083    /* add eax,yy */
#define ADDAX_LONG 0x05		/* add eax,yyyyyyyy */


#define ADD_DX_BYTE 0xC283
#define CMP_MDX_LONG 0x3A81
#define MOV_AX_MDX 0x028B


#define	ADCBX      0xD383    /* adc ebx, */


#define IMUL_BX    0xEBF7    /* imul ebx */
#define IDIV_BX    0xFBF7    /* idiv ebx */
#define IDIV_DX    0xFAF7    /* idiv edx */


#define NOTBX	   0xD3F7    /* not ebx */     
#define	NOTAX      0xD0F7    /* not eax */
#define CMP_AX     0x3D      /* cmp eax,yyyyyyyy */
#define CMP_BX     0xFB81    /* cmp ebx,yyyyyyyy */

#define LEA_DX_AX_8 0x508D
#define MOV_DX_MDX_8 0x528B
#define ADD_DXAX 0xC201



#define MOV_BX_SP  0xDC8B    /* mov ebx,esp */
#define MOV_CX_AX  0xC88B    /* mov ecx,eax */
#define CDQ        0x99	     /* cdq   (eax->edx:eax) */

#define FLD_M_BX     0x03D9  /* fld  dword [ebx] */
#define FLD_QWM_BX   0x03DD  /* fld  qword [ebx] */
#define FILD_QWM_BX  0x2BDF  /* fild  qword [ebx] */
#define FILD_M_BX    0x03DB  /* fild  dword [ebx] */

#define FSTP_M_BX    0x1BD9  /* fstp  dword [ebx] */
#define FSTP_QWM_BX  0x1BDD  /* fstp qword [ebx] */
#define FISTP_M_BX   0x1BDB  /* fistp dword [ebx] */
#define FISTP_QWM_BX 0x3BDF  /* fistp qword [ebx] */

#define FADDP_ST1    0xC1DE  /* faddp st1,st */
#define FSUBRP_ST1   0xE1DE  /* fsubrp st1,st */
#define FMULP_ST1  0xC9DE    /* fmulp st1,st */
#define FDIVRP_ST1 0xF1DE    /* fdivrp st1,st */
#define FPREM      0xF8D9    /* fprem */
#define FCHS       0xE0D9    /* fchs */

#define FCOMPP     0xD9DE    /* fcompp */
#define FSTSW_AX   0xE0DF    /* fstsw ax */
#define FSTCW_MBP  0x7DD9    /* fstcw [ebp-xx] */
#define FLDCW_MBP  0x6DD9    /* fldcw [ebp-xx] */


#define FLDW_MSP   0x04D9    /* fld  dword [esp] */
#define FSTPW_MSP  0x1CD9    /* similar */
#define FLDQW_MSP  0x04DD    /* ditto */
#define FSTPQW_MSP 0x1CDD
#define FISTP_MSP  0x1CDB
#define FISTPQ_MSP 0x3CDF
#define FILDW_MSP  0x04DB
#define FILDQW_MSP 0x2CDF

#define SP_ADDR_BYTE3  0x24


#define MOV_BX_MSP      0x1C8B // do not forget Byte3: this is SP_ADDR_BYTE3
#define MOV_BX_MSP_BYTE 0x5C8B //+Byte3!  XX
#define MOV_BX_MSP_LONG 0x9C8B //+Byte3!  YYYYYYYY

#define CMP_MAX_CX 0x4839      // cmp [eax],ecx

#define	LEA_BX 0x1C8D	       //+ different Byte 3
#define LEA_BX_AX_LONG 0x988D /* lea ebx,[eax+yyyyyyyy] */


#define PUSHLONG2  0x6A      /* push yy  (short version) */
#define PUSHLONG   0x68      /* push yyyyyyyy */
#define JCXZ       0xE3      /* JCXZ ..*/
#define JZ         0x840F    /* jz .... */
#define JNZ        0x850F    /* jnz .... */
#define JL         0x8C0F    /* jl .... */
#define JLE        0x8E0F    /* jle.... */
#define JG         0x8F0F    /* jg .... */

#define JNB        0x830F
#define JNA        0x860F

#define JGE        0x8D0F    /* jge.... */
/// 
#define JMP        0xE990    /* nop + jmp_near:  should be 2 byte, just like jz etc */

#define JMP1       0xE9      /* jmp_near */
#define CALL       0xE8      /* call */

// FIXME: change opcode names for more difference between BYTEs and WORDs
#define SAHF       0x9e      /* sahf */
#define JB         0x72      /* jb .. */
#define JE         0x74      /* je ..  */
#define JNE	   0x75	     /* jne .. */
#define JAE 	   0x73	     /* jae .. */
#define JA         0x77      /* ja .. */
#define JNC        0x73      /* jnc .. */
#define JNS 	   0x79	     /* jns .. */
#define JNGE       0x7C      /* jnge .. */
#define JNL        0x7D      /* jnl .. */
#define JNLE       0x7F      /* jnle .. */

#define JMPS       0xEB      /* jmp_short .. */

#define ADD_SP_BYTE  0xC483  /* add esp,yy */
#define ADD_SP_LONG  0xC481  /* add esp,yyyyyyyy */
#define SUB_SP_BYTE  0xEC83  /* sub esp,yy */
#define SUB_SP_LONG  0xEC81  /* sub esp,yyyyyyyy */

#define PUSHPOPAX  0x5850
#define PUSHAXPOPDX  0x5A50
#define PUSHAXPOPCX  0x5950
#define POPPUSHAX  0x5058 /* this cannot be easily replaced by nulls !! */

#define PUSH_SP    0x54

#define POPAX	   0x58
#define POPBX      0x5B
#define PUSHAX     0x50
#define PUSHDX     0x52
#define POPCX      0x59
#define PUSHCX     0x51
#define PUSHBX     0x53
#define	POPDX      0x5A
#define PUSHDX     0x52

#define POPBP      0x5D
#define POPDI      0x5F
#define POPSI      0x5E

#define PUSHSI     0x56
#define PUSHDI     0x57
#define PUSHBP     0x55
#define MOV_BPSP   0xE589    /* mov ebp,esp */
#define MOV_SPBP   0xEC89    /* mov esp,ebp */

#define DEBUGBREAK 0xCC      /* int3 */

#define CMC        0xF5      /*CMC*/

#define CWDE       0x98
#define CWD        0x99
#define RETN       0xC3      /* ret near */
#define CALL_EBX   0xD3FF    /* call ebx */
#define CALL_ECX   0xD1FF    /* call ecx */
#define CALL_EAX   0xD0FF    /* call eax */

#define JMP_BX     0xE3FF    /* jmp ebx */

/* some preassembled 4byter */
#define CALL_ADDSP 0xC483D3FF  /* call [ebx] - add esp,yy */
#define POPBPDISIBX 0x5B5E5F5D /* pop ebp - pop edi - pop esi - pop ebx */
#define MOVSXAL     0x90C0BE0F  /* signed mov eax,al */

/* Different way of specifying opcodes */
#define OR_R_R( reg1, reg2 )\
	emit((se, "or %s,%s\n", rname[reg1], rname[reg2]));\
	CB(0x0B); CB( 0xC0 |(reg1<<3) | reg2)
	
#define MOV_R_MBX8( reg, off )\
	emit((se, "mov %s, [ebx+%d]\n", rname[reg], off ));\
	CB(0x8B); CB( 0x43 | (reg<<3)); CB(off)
	
#define SHR_R( reg, immed )\
	emit((se, "shr %s,%d\n", rname[reg], immed));\
	CB(0xC1); CB( 0xE8 | reg ); CB(immed)
	
// direction in cmp ???
#define CMP_R_R( reg1, reg2 )\
	emit((se,"cmp %s,%s\n", rname[reg1], rname[reg2]));\
	CB(0x3B); CB(0xC0 | (reg1 << 3) | reg2)

// you need to specify scale encoded (0=x1,1=x2,2=x4,3=x8)
#define SIB_SCALE1 0
#define SIB_SCALE2 1
#define SIB_SCALE4 2
#define SIB_SCALE8 3
#define SIB_RNONE 4
#define SIB( scale, scaledreg, reg ) ( (scale << 6) | (scaledreg << 3) | reg )

#define MOV_R_Rsib( reg, sibbyte )\
	emit((se, "mov %s,[%s]\n",rname[reg], sibdecode(sibbyte)));\
	CB( 0x8B ); CB( (reg<<3) | 0x04 ); CB(sibbyte)
	
#define MOV_R_Rsiboffs8( reg, sibbyte, offset )\
	emit((se, "mov %s,[%s+%d]\n",rname[reg], sibdecode(sibbyte), offset));\
	CB( 0x8B ); CB( (reg<<3) | 0x44 ); CB(sibbyte); CB( offset )
	
#define MOV_R_Rsiboffs32( reg, sibbyte, offset )\
	emit((se, "mov %s,[%s+%d]\n",rname[reg], sibdecode(sibbyte), offset));\
	CB( 0x8B ); CB( (reg<<3) | 0x84 ); CB(sibbyte); CL( offset )
	
#define MOV_Rsib_R( sibbyte, reg )\
	emit((se, "mov [%s],%s\n",sibdecode(sibbyte), rname[reg]));\
	CB( 0x89 ); CB( (reg<<3) | 0x04 ); CB(sibbyte)	
	
#define MOV_Rsiboffs8_R( sibbyte, offset, reg )\
	emit((se, "mov [%s+%d],%s\n", sibdecode(sibbyte), offset, rname[reg]));\
	CB( 0x89 ); CB( (reg<<3) | 0x44 ); CB(sibbyte); CB( offset )
	
#define MOV_Rsiboffs32_R( sibbyte, offset, reg )\
	emit((se, "mov [%s+%d],%s\n", sibdecode(sibbyte), offset, rname[reg]));\
	CB( 0x89 ); CB( (reg<<3) | 0x84 ); CB(sibbyte); CL( offset )
	
#define MOV_Rsib_8R( sibbyte, reg )\
	emit((se, "mov [%s],%s\n",sibdecode(sibbyte), rname8[reg]));\
	CB( 0x88 ); CB( (reg<<3) | 0x04 ); CB(sibbyte)
	
#define MOV_R_mem( reg, adr )\
	emit((se, "mov %s,[%p]\n", rname[reg], adr));\
	CB( 0x8b ); CB( (reg << 3) | 0x05); CL( adr )
	
#define MOV_mem_R( adr, reg )\
	emit((se, "mov [%p],%s\n", adr, rname[reg]));\
	CB( 0x89 ); CB( (reg << 3) | 0x05); CL( adr )

#define MOV_R_Rmem( reg1, reg2 )\
	emit((se, "mov %s, [%s]\n", rname[reg1], rname[reg2]));\
	CB( 0x8b ); CB( (reg1<<3) | reg2 )
	
#define MOV_Rmem_R( reg1, reg2 )\
	emit((se, "mov [%s],%s\n", rname[reg1], rname[reg2]));\
	CB( 0x89 ); CB( (reg2<<3) | reg1 )
	
#define MOV_R_Rmemoffs8( reg1, reg2, offset )\
	emit((se, "mov %s,[%s+%d]\n", rname[reg1], rname[reg2], offset));\
	CB( 0x8b ); CB(0x40 |(reg1<<3)|reg2); CB( offset )
	
#define MOV_R_Rmemoffs32( reg1, reg2, offset )\
	emit((se, "mov %s,[%s+%d]\n", rname[reg1], rname[reg2], offset));\
	CB( 0x8b ); CB(0x80 |(reg1<<3)|reg2); CL( offset )

#define MOV_R_Rmemoffs_(reg1, reg2, offset ) \
	if ( (offset < 128) && (offset > -129) )  \
		{ MOV_R_Rmemoffs8(reg1,reg2,offset); } \
	else \
		{ MOV_R_Rmemoffs32(reg1,reg2,offset); }
		
#define MOV_Rmemoffs8_R( reg1, offset, reg2 )\
	emit((se, "mov [%s+%d],%s\n", rname[reg1], offset, rname[reg2]));\
	CB( 0x89 ); CB(0x40 |(reg2<<3)|reg1); CB( offset )
	
#define MOV_Rmemoffs32_R( reg1, offset, reg2 )\
	emit((se, "mov [%s+%d],%s\n", rname[reg1], offset, rname[reg2]));\
	CB( 0x89 ); CB(0x80 |(reg2<<3)|reg1); CL( offset )

#define MOV_Rmemoffs__R(reg1, offset, reg2 ) \
        if ( (offset < 128) && (offset > -129) )  \
                { MOV_Rmemoffs8_R(reg1,offset,reg2); } \
        else \
                { MOV_Rmemoffs32_R(reg1,offset,reg2); }

#define PUSH_Roffs8( reg, offset ) \
	emit((se, "push [%s+%d]\n", rname[reg], offset));\
	CB( 0xFF ); CB( 0x70 | reg ); CB(offset)
	
#define MOV_R_R( reg1, reg2 ) \
	emit((se, "mov %s,%s\n", rname[reg1], rname[reg2]));\
	CB( 0x89 ); CB(0xc0 | (reg2<<3) | reg1 )

#endif
