# =============================================================================
#
# File:		dsk_help.tcl
# Project:	TkDesk
#
# Started:	22.10.94
# Changed:	22.10.94
# Author:	cb
#
# Description:	Contains the on-line help and "About"-dialog.
#
# Copyright (C) 1996  Christian Bolik
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# See the file "COPYING" in the base directory of this distribution
# for more.
#
# -----------------------------------------------------------------------------
#
# Sections:
#	proc dsk_about {}
#	proc dsk_help_window {}
#
# =============================================================================

#
# -----------------------------------------------------------------------------
#
# Proc:		dsk_about
# Args:		none
# Returns: 	""
# Desc:		Shows the "About..." dialog box.
# Side-FX:	none
#

proc dsk_about {} {
    global tkdesk

    set t .dsk_about
    if [winfo exists $t] {
	cb_raise $t
	$t.la config -image dsk_blank
	update idletasks
	cb_aboutAnim $t.la $tkdesk(library)/about/tkdesk 10 0 blue3
	dsk_sound dsk_about
	return
    }

    toplevel $t
    wm withdraw $t

    frame $t.f -bd 3 -relief raised
    pack $t.f -ipadx 4 -ipady 4
    
    image create bitmap dsk_blank \
	    -data [exec gzip -cd $tkdesk(library)/about/blank.xbm.gz]
    label $t.la -image dsk_blank
    pack $t.la -in $t.f -padx $tkdesk(pad) -pady [expr $tkdesk(pad) + 2]

    message $t.m -aspect 1000 -justify center \
	    -font -*-Helvetica-Medium-O-Normal--*-140-*-*-*-*-*-* \
	    -text "A File Manager for\nUnix and the X Window System\n\nVersion $tkdesk(version), dated $tkdesk(date)\n\nWritten by Christian Bolik\n(zzhibol@rrzn-user.uni-hannover.de)\n\nI hope you like it! In any case,\nplease send me a short email,\nand tell me what you think about TkDesk.\nThanks a lot!"
    pack $t.m -in $t.f -padx $tkdesk(pad) -pady $tkdesk(pad) -ipady 1

    button $t.b -text "OK" -width 6 -command "destroy $t"
    #button $t.b -image [cb_image $tkdesk(library)/images/comet.xpm] \
	#    -command "destroy $t"
    pack $t.b -in $t.f -padx $tkdesk(pad) -pady $tkdesk(pad)

    wm title $t "About TkDesk"
    wm iconname $t "About TkDesk"
    wm resizable $t 0 0
    cb_centerToplevel $t
    wm deiconify $t

    # start the animation:
    update idletasks
    cb_aboutAnim $t.la $tkdesk(library)/about/tkdesk 10 0 blue3
    dsk_sound dsk_about
}

