/*--------------------------------*-C-*---------------------------------*
 * File:	main.h
 *
 * Copyright 1992 John Bovey, University of Kent at Canterbury.
 *
 * You can do what you like with this source code as long as you don't try
 * to make money out of it and you include an unaltered copy of this
 * message (including the copyright).
 *
 * This module has been heavily modified by R. Nation
 * <nation@rocket.sanders.lockheed.com>
 * No additional restrictions are applied
 *
 * Additional modifications by mj olesen <olesen@me.QueensU.CA>
 * No additional restrictions are applied.
 *
 * As usual, the author accepts no responsibility for anything, nor does
 * he guarantee anything whatsoever.
 *----------------------------------------------------------------------*/
#ifndef _MAIN_H
#define _MAIN_H

#include "VERSION.h"
#include "config.h"
#include "feature.h"

#include <assert.h>
#include <ctype.h>
#include <stdio.h>

/* STDC_HEADERS
 * don't check for these using configure, since we need them regardless.
 * if you don't have them -- figure a workaround.
 *
 * Sun is often reported as not being STDC_HEADERS, but it's not true
 * for our purposes and only generates spurious bug reports.
 */
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>

#ifndef EXIT_SUCCESS		/* missing from <stdlib.h> */
# define EXIT_SUCCESS	0	/* exit function success */
# define EXIT_FAILURE	1	/* exit function failure */
#endif

#include <X11/Intrinsic.h>	/* Xlib, Xutil, Xresource, Xfuncproto */

#define NEW_name	0	/* don't change these values, they must */
#define NEW_iconName	1	/* match the normal xterm convention for */
#define NEW_title	2	/* interactive name setting */

typedef struct {
   int fwidth, fheight;    /* font width and height [pixels] */
   int width,  height;	/* window size [pixels] */
   int ncol, nrow;	/* window size [characters] */
   int focus;		/* window has focus */
   int saveLines;	/* number of lines that fit in scrollback */
   int hist_count;	/* number of line actually scrolled */
   int hist_start;	/* scrollback view starts here */
   Window parent, vt;	/* parent (main) and vt100 window */
   GC gc;		/* GC for drawing text */
   XFontStruct	*font;	/* main font structure */
#ifdef USE_BOLDFONT
   XFontStruct	*boldFont;	/* bold font */
#endif
#ifdef KANJI
   XFontStruct	*kanji;	/* Kanji font structure */
#endif
} TermWin_t;

extern TermWin_t TermWin;

/* gap between the text and window edges (could be made configurable) */
#define TermWin_internalBorder	2

extern Display		*Xdisplay;

#define Xscreen		DefaultScreen(Xdisplay)
#define Xcmap		DefaultColormap(Xdisplay,Xscreen)
#define Xdepth		DefaultDepth(Xdisplay,Xscreen)
#ifdef DEBUG_DEPTH
# undef Xdepth
# define Xdepth		DEBUG_DEPTH
#endif

extern unsigned long Options;
#define	Opt_console	(1LU<<0)
#define Opt_loginShell	(1LU<<1)
#define Opt_iconic	(1LU<<2)
#define Opt_visualBell	(1LU<<3)
#define Opt_mapAlert	(1LU<<4)
#define Opt_reverseVideo (1LU<<5)
#define Opt_utmpInhibit	(1LU<<6)
#define Opt_scrollBar	(1LU<<7)
#define Opt_meta8	(1LU<<8)

/* place holder used for parsing command-line options */
#define Opt_Boolean	(1LU<<31)

/*
 *
 */

extern const char *display_name;
extern const char *rs_name;	/* client instance (resource name) */

#define fgColor		0
#define bgColor		1

/* 0-7: black, red, green, yellow, blue, magenta, cyan, white */
#define minColor	2
#define maxColor	(minColor+7)
#define blackColor	(minColor)

/* 10-17: Bright black, red, green, yellow, blue, magenta, cyan, white */
#ifdef NO_BRIGHTCOLOR
# define whiteColor	(maxColor)
#else	/* NO_BRIGHTCOLOR */
# define minBright	(maxColor+1)
# define maxBright	(minBright+7)
# define whiteColor	(maxBright)
#endif	/* NO_BRIGHTCOLOR */

#define NCOLORS		(whiteColor+1)

#ifdef NO_CURSORCOLOR
# define NCURSOR	0
#else	/* NO_CURSORCOLOR */
# define NCURSOR	2
# define cursorColor	(NCOLORS)
# define cursorColor2	(cursorColor + 1)
#endif	/* NO_CURSORCOLOR */

#ifdef NO_BOLDUNDERLINE
# define NBOLDULINE	0
#else	/* NO_BOLDUNDERLINE */
# define NBOLDULINE	2
# define colorBD	(NCOLORS + NCURSOR)
# define colorUL	(colorBD + 1)
#endif	/* NO_BOLDUNDERLINE */

#ifdef XTERM_SCROLLBAR
# define NSCROLLCOLORS	0
#else
# define NSCROLLCOLORS	1
# define scrollColor	(NCOLORS + NCURSOR + NBOLDULINE)
#endif

#define RestoreFG	39	/* restore default fg color */
#define RestoreBG	49	/* restore default bg color */

extern const char *rs_color [NCOLORS + NCURSOR + NBOLDULINE + NSCROLLCOLORS];
extern Pixel PixColors [NCOLORS + NCURSOR + NBOLDULINE + NSCROLLCOLORS];

extern KeySym ks_bigfont;
extern KeySym ks_smallfont;

#define NFONTS		5
extern const char *rs_font [NFONTS];
#ifdef KANJI
extern const char *rs_kfont [NFONTS];
#endif
#ifdef USE_BOLDFONT
extern const char *rs_boldFont;
#endif

#ifdef PRINTPIPE
extern const char *rs_print_pipe;
extern KeySym ks_printscreen;
#endif
#ifdef PASTE_KEY
extern KeySym ks_paste;
#endif

#ifndef NO_MULTIPLE_CLICK
extern const char *rs_cutchars;
#endif

#ifdef __cplusplus
extern "C" {
#endif
   extern const char *my_basename (const char *string);
   extern void	resize_window (void);
   extern void	xterm_seq (int op, const char *str);
   extern void	print_error (const char *fmt, ...);
   extern void	change_font (int dirn);
   extern void	set_width (unsigned int ncol);
#ifdef __cplusplus
}
#endif

#endif	/* whole file */
/*----------------------- end-of-file (C header) -----------------------*/
