/*
 *  Printer - the OffiX print manager
 *  Copyright (c) 1996 Andr Hentz
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
 
#include "List.h"
#include <stdlib.h>
#ifndef NULL
#define NULL 0
#endif /* !NULL */

List *NewList()
{
	List *tmp;
	tmp = (List*)malloc(sizeof(List));
	if (!tmp)
		return NULL;
	tmp->last = tmp->first = NULL;	
	return tmp;
}

void FreeList(List *ListName)
{
	ListEntry *toFree;
	if(!ListName)
	  	return;
	while(ListName->first)
	{
		toFree = ListName->first;
		ListName->first = toFree->next;
		free(toFree->string);
		free(toFree);
	}
	free(ListName);
}


ListEntry *NewListEntry(List *ListName, char* string)
{
  	ListEntry *tmp;
	tmp = (ListEntry*)malloc(sizeof(ListEntry));
	if (!tmp)
		return NULL;
	tmp->string = (char*)malloc(strlen(string)+1);
	if (!(tmp->string))
		return NULL;
	strcpy(tmp->string, string);
	tmp->next = NULL;
	if(ListName->last)
		ListName->last->next = tmp;
	else
	  	ListName->first = tmp;
	ListName->last = tmp;
	return tmp;
}

