.TH MOUNTD 8 "13 Octover 1993"
.SH NAME
mountd \- NFS mount daemon
.SH SYNOPSIS
.B /usr/sbin/rpc.mountd
.B "[\ \-f\ exports-file\ ]"
.B "[\ \-d\ facility\ ]"
.B "[\ \-Dhnprv\ ]"
.B "[\ \-\-debug\ ]"
.B "[\ \-\-exports\-file=file\ ]"
.B "[\ \-\-help\ ]"
.B "[\ \-\-allow\-non\-root\ ]"
.B "[\ \-\-re\-export\ ]"
.B "[\ \-\-version\ ]"
.SH DESCRIPTION
The
.I mountd
program is an NFS mount daemon.
.SH OPTIONS
.TP
.BR \-f " or " \-\-exports\-file
This option specifies the exports file, listing the clients that this server
is prepared to serve and parameters to apply to each such mount (see
exports(5)).
By default exports are read from
.IR /etc/exports .
.TP
.BR \-d " or " \-\-debug
Log each transaction verbosely to standard error. Valid log facilities
are
.I call
for the logging of all calls, 
.I auth
for client authentication, 
.I fhcache
for operations of the file handle cache, and
.I rmtab
for manipulation of 
.IR /etc/rmtab .
By default, log output is sent to
syslogd unless the daemon runs in the foreground.
.TP
.BR \-F " or " \-\-foreground
Unlike normal in operation,
.I mountd
will not detach from the terminal when given this option. When debugging is
requested, it will be sent to standard error.
.TP
.BR \-h " or " \-\-help
Provide a short help summary.
.TP
.BR \-n " or " \-\-allow\-non\-root
Allow incoming mount requests to be honored even if they do not
originate from reserved IP ports.  Some older NFS client implementations
require this.  Some newer NFS client implementations don't believe
in reserved port checking.
.TP
.BR \-p " or " \-\-promiscuous
Put the server into promiscuous mode where it will serve any host
on the network.
.TP
.BR \-r " or " \-\-re\-export
Allow imported NFS file-systems to be exported.  This can be used to
turn a machine into an NFS multiplier.  Caution should be used when
re-exporting loopback NFS mounts because re-entering the mount point
will result in deadlock between the NFS client and the NFS server.
.TP
.BR \-v " or " \-\-version
Report the current version number of the program.
.SH BUGS
This implementation of
.I mountd
does keep track of remote mounts and stores them in 
.IR /etc/rmtab .
This information can be displayed using the
.I showmount
command.  However, it is not guaranteed that this information is always
accurate because clients may unmount a volume without notifying
.IR mountd ,
or clients may simply crash.
.SH SIGNALS
When receiving a SIGHUP, 
.I mountd
will re-read the
.I exports
file. Note that to make export changes take effect, you have to send
.I nfsd
a SIGHUP as well.
.SH FILES
.I /etc/exports
.br
.I /etc/rmtab
.SH "SEE ALSO"
exports(5), nfsd(8), ugidd(8C), showmount(8).
