/*
 * route.c - diald routing code.
 *
 * Copyright (c) 1994, 1995, 1996 Eric Schenk.
 * All rights reserved. Please see the file LICENSE which should be
 * distributed with this software for terms of use.
 */

#include "diald.h"

/* set up a point to point route for a device */
void set_ptp(char *itype, int iface, char *rip, int metric)
{
    char buf[128];
    int res;
    if (debug&DEBUG_VERBOSE)
	syslog(LOG_INFO, "Setting pointopoint route for %s%d",itype,iface);
    sprintf(buf,"%s add %s metric %d dev %s%d",PATH_ROUTE,rip,metric,itype,iface); 
    res = system(buf);
    report_system_result(res,buf);
}

/*
 * Add in a direct and default route to the slip link.
 * The default route is only added if the "default" option was
 * requested by the user.
 */

void add_routes(char *itype, int iface, char *lip, char *rip, int metric)
{
    char buf[128];
    int res;

    if (debug&DEBUG_VERBOSE)
	syslog(LOG_INFO,"Establishing routes for %s%d",itype,iface);

    sprintf(buf,"INTERFACE\n%s%d\n%s\n%s\n", itype, iface, lip, rip);
    if (monitors) mon_write(buf,strlen(buf));
    /* if (mon_fp) fflush(mon_fp); */

    /* Add in a default route for the link */
    /* FIXME: should this refuse to add if a default route exists? */
    if (default_route) {
	/* use different gateways for the proxy and link routes
	 * This is done so that on 1.3.X kernels both of the
	 * routes can coexist. (It is not clear to me that
         * the fact that they cannot coexist when the gateway is
         * identical, but the device is different, is not a kernel bug...
         */
	if (metric == 500)
	    sprintf(buf,"%s add default metric %d dev %s%d",PATH_ROUTE,metric,itype,iface);
	else
	    sprintf(buf,"%s add default gw %s metric %d dev %s%d",PATH_ROUTE,rip,metric,itype,iface);
        res = system(buf);
    	report_system_result(res,buf);
    }

    /* call addroute script */
    if (addroute) {
        sprintf(buf,"%s %s%d %s %s %s %d",
	    addroute,itype,iface,(netmask)?netmask:"default",lip,rip,metric);
	res = system(buf);
    	report_system_result(res,buf);
    }

    if (proxyarp) set_proxyarp(inet_addr(rip));
}

/*
 * Call the delroute script and take the pty out of slip mode.
 */
void del_routes(char *itype, int iface, char *lip, char *rip, int metric)
{
    char buf[128];
    int res;

    if (debug&DEBUG_VERBOSE)
	syslog(LOG_INFO,"Removing routes for %s%d",itype,iface);

    if (proxyarp) clear_proxyarp(inet_addr(rip));

    if (delroute) {
	/* call delroute <iface> <netmask> <local> <remote> */
        sprintf(buf,"%s %s%d %s %s %s %d",
	    delroute,itype,iface,(netmask)?netmask:"default",lip,rip,metric);
        res = system(buf);
    	report_system_result(res,buf);
    }
}
