#include <sys/types.h>
#include <sys/socket.h>
#include <linux/ax25.h>

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#include "config.h"

void main(int argc, char *argv[])
{
	struct full_sockaddr_ax25 dest;
	struct full_sockaddr_ax25 src;
	int dlen;
	int s;
	
	if(config_load_ports()==-1)
	{
		fprintf(stderr,"%s: No ports defined.\n",argv[0]);
		exit(1);
	}
	
	if(argc!=2)
	{
		fprintf(stderr,"%s \"banner text\"\n",argv[0]);
		exit(1);
	}
	
	
	dlen=convert_call("IDENT",&dest);
		
	while(1)
	{
		int n=0;
		int len;
		while(n<config_num_ports())
		{
			s=socket(AF_AX25,SOCK_DGRAM,0);
			if(s==-1)
			{
				perror("socket");
				exit(1);
			}
			len=convert_call(config_get_addr(n),&src);
			if(len==-1)
			{
				fprintf(stderr,"Unable to convert callsign '%s'.\n",config_get_addr(n));
				exit(1);
			}
			printf("len=%d should be %d\n",len,sizeof(struct sockaddr_ax25));
			if(bind(s,(struct sockaddr *)&src,len)==-1)
			{
				perror("bind");
				exit(1);
			}
		
			printf("sending\n");
			if(sendto(s,argv[1],strlen(argv[1]),0,(struct sockaddr *)&dest,dlen)==-1)
				perror("send");
			close(s);
			n++;
		}
		sleep(30*60);
	}
}
