/* @(#) $Header: arpdump.c,v 1.5 91/03/28 19:38:59 deyke Exp $ */

/* ARP packet tracing routines
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include "global.h"

#define	ARP_REQUEST	1
#define	ARP_REPLY	2
#define	REVARP_REQUEST	3
#define	REVARP_REPLY	4

#define	ARP_AX25	3

#define	AXALEN		7

#define	PID_IP		0xCC

void arp_dump(unsigned char *data, int length)
{
	int is_ip = 0;
	int hardware;
	int protocol;
	int hwlen;
	int pralen;
	int operation;
	unsigned char *shwaddr, *sprotaddr;
	unsigned char *thwaddr, *tprotaddr;
	char tmp[25];

	fprintf(stdout, "ARP: len %d", length);
	if (length < 16)
	{
		fprintf(stdout, " bad packet\n");
		return;
	}

	hardware  = get16(data + 0);
	protocol  = get16(data + 2);
	hwlen     = data[4];
	pralen    = data[5];
	operation = get16(data + 6);
	
	if (hardware != ARP_AX25)
	{
		fprintf(stdout, " non-AX25 ARP packet\n");
		return;
	}

	fprintf(stdout, " hwtype AX25");

	/* Print hardware length only if it doesn't match
	 * the length in the known types table
	 */
	if (hwlen != AXALEN)
		fprintf(stdout, " hwlen %d", hwlen);

	if (protocol == PID_IP)
	{
		fprintf(stdout, " prot IP");
		is_ip = 1;
	}
	else
	{
		fprintf(stdout, " prot 0x%x prlen %d", protocol, pralen);
	}

	switch (operation)
	{
	case ARP_REQUEST:
		fprintf(stdout, " op REQUEST");
		break;
	case ARP_REPLY:
		fprintf(stdout, " op REPLY");
		break;
	case REVARP_REQUEST:
		fprintf(stdout, " op REVERSE REQUEST");
		break;
	case REVARP_REPLY:
		fprintf(stdout, " op REVERSE REPLY");
		break;
	default:
		fprintf(stdout, " op %d", operation);
		break;
	}
	
	shwaddr   = data + 8;
	sprotaddr = shwaddr + hwlen;
	
	thwaddr   = sprotaddr + pralen;
	tprotaddr = thwaddr + hwlen; 
	
	fprintf(stdout, "\nsender");
	if (is_ip) fprintf(stdout, " IPaddr %d.%d.%d.%d",
			sprotaddr[0], sprotaddr[1],
			sprotaddr[2], sprotaddr[3]);
	fprintf(stdout, " hwaddr %s\n", pax25(tmp, shwaddr));

	fprintf(stdout,"target");
	if (is_ip) fprintf(stdout, " IPaddr %d.%d.%d.%d",
			tprotaddr[0], tprotaddr[1],
			tprotaddr[2], tprotaddr[3]);
	fprintf(stdout, " hwaddr %s\n", pax25(tmp, thwaddr));
}
