/*************************************************************************
 *  TinyFugue - programmable mud client
 *  Copyright (C) 1993, 1994, 1995, 1996 Ken Keys
 *
 *  TinyFugue (aka "tf") is protected under the terms of the GNU
 *  General Public License.  See the file "COPYING" for details.
 ************************************************************************/
/* $Id: socket.h,v 35004.10 1996/04/08 00:20:12 hawkeye Exp $ */

#ifndef SOCKET_H
#define SOCKET_H

extern void    NDECL(main_loop);
extern void    NDECL(close_sockets);
extern void    NDECL(init_sock);
extern int     FDECL(is_active,(int fd));
extern void    FDECL(readers_clear,(int fd));
extern void    FDECL(readers_set,(int fd));
extern TIME_T  FDECL(sockidle,(CONST char *name));
extern void    NDECL(tog_bg);
extern char   *NDECL(fgname);
extern struct World *NDECL(xworld);
extern int     FDECL(openworld,(CONST char *name, CONST char *port,
                     int autologin, int quietlogin));
extern int     FDECL(opensock,(struct World *w, int autologin, int quietlogin));
extern void    FDECL(world_output,(struct World *world, Aline *aline));
extern int     FDECL(send_line,(CONST char *s, unsigned int len, int eol_flag));
extern Aline  *NDECL(fgprompt);
extern void    NDECL(tog_lp);
extern void    NDECL(transmit_window_size);
extern int     FDECL(local_echo,(int flag));
extern CONST char *FDECL(world_info,(CONST char *fieldname));

#endif /* SOCKET_H */
